/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.framework.ext;

import cn.weforward.common.ResultPage;
import cn.weforward.framework.ApiException;
import cn.weforward.framework.ExceptionHandler;
import cn.weforward.framework.KeepServiceOrigin;
import cn.weforward.framework.WeforwardResource;
import cn.weforward.framework.WeforwardRole;
import cn.weforward.framework.WeforwardSession;
import cn.weforward.framework.doc.DocPageParams;
import cn.weforward.framework.ext.ArgsProvider;
import cn.weforward.framework.support.AbstractApiMethod;
import cn.weforward.framework.support.Global;
import cn.weforward.protocol.Header;
import cn.weforward.protocol.Request;
import cn.weforward.protocol.Response;
import cn.weforward.protocol.client.util.MappedUtil;
import cn.weforward.protocol.datatype.DtBase;
import cn.weforward.protocol.datatype.DtObject;
import cn.weforward.protocol.ext.ObjectMapperSet;
import cn.weforward.protocol.ops.Role;
import cn.weforward.protocol.ops.User;
import cn.weforward.protocol.support.PageData;
import cn.weforward.protocol.support.datatype.FriendlyObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReflectMethod
extends AbstractApiMethod {
    private static final Logger _Logger = LoggerFactory.getLogger(ReflectMethod.class);
    protected Object m_Methods;
    protected Method m_Method;
    protected ObjectMapperSet m_ObjectMapperSet;
    protected List<Method> m_Befores;
    protected List<Method> m_Afters;
    protected List<Method> m_Exceptions;
    protected List<ArgsProvider> m_ArgsProviders;
    protected boolean m_KeepServiceOrigin;
    protected List<Integer> m_AllowRoles;
    protected List<Integer> m_DisallowRoles;
    public static ArgsProvider _GLOBAL_PROVIDER = new ArgsProvider(){

        @Override
        public void before(DtObject params) {
            DtBase base = params.getAttribute("_global");
            if (base != null) {
                Global.TLS.put(new Global(base));
            }
        }

        @Override
        public Object create(DtObject params, Class<?> clazz) {
            return Global.TLS.get();
        }

        @Override
        public boolean accept(Class<?> clazz) {
            return Global.class.isAssignableFrom(clazz);
        }

        @Override
        public void after(Object v) {
        }
    };

    public ReflectMethod(String name, Object methods, Method method) {
        super(name);
        this.m_Methods = methods;
        this.m_Method = method;
        this.m_ArgsProviders = new ArrayList<ArgsProvider>();
        this.m_ArgsProviders.add(_GLOBAL_PROVIDER);
        Class<?> clazz = methods.getClass();
        this.m_KeepServiceOrigin = clazz.isAnnotationPresent(KeepServiceOrigin.class) || method.isAnnotationPresent(KeepServiceOrigin.class);
        WeforwardRole roles = method.getAnnotation(WeforwardRole.class);
        if (roles == null) {
            roles = clazz.getAnnotation(WeforwardRole.class);
        }
        if (roles != null) {
            this.m_AllowRoles = ReflectMethod.toList(roles.allow());
            this.m_DisallowRoles = ReflectMethod.toList(roles.disallow());
        }
    }

    private static List<Integer> toList(int[] allow) {
        if (allow == null) {
            return null;
        }
        ArrayList<Integer> list = new ArrayList<Integer>(allow.length);
        int[] nArray = allow;
        int n = allow.length;
        int n2 = 0;
        while (n2 < n) {
            int v = nArray[n2];
            list.add(v);
            ++n2;
        }
        return list;
    }

    public void setObjectMapperSet(ObjectMapperSet m) {
        this.m_ObjectMapperSet = m;
    }

    public void setBefores(List<Method> list) {
        this.m_Befores = list;
    }

    public void setAfters(List<Method> list) {
        this.m_Afters = list;
    }

    public void setExceptions(List<Method> list) {
        this.m_Exceptions = list;
    }

    @Override
    public DtBase handle(String path, DtObject params, Request request, Response response) throws ApiException {
        Object returnVal;
        if (this.m_KeepServiceOrigin) {
            response.setMarks(1);
        }
        try {
            Object v = this.beforeInvoke(path, params, request, response);
            Object[] args = this.newArgs(path, params, request, response, this.m_Method.getParameterTypes(), v);
            returnVal = args == null ? this.m_Method.invoke(this.m_Methods, new Object[0]) : this.m_Method.invoke(this.m_Methods, args);
            returnVal = this.afterInvoker(path, params, request, response, returnVal);
        }
        catch (InvocationTargetException e) {
            Throwable target = e.getTargetException();
            try {
                target = this.exception(target);
            }
            catch (InvocationTargetException ee) {
                throw new IllegalArgumentException("\u65b9\u6cd5\u8c03\u7528\u5931\u8d25", ee.getTargetException());
            }
            catch (IllegalAccessException | IllegalArgumentException ee) {
                throw new IllegalArgumentException("\u65b9\u6cd5\u8c03\u7528\u5931\u8d25", ee);
            }
            if (target instanceof ApiException) {
                throw (ApiException)target;
            }
            if (target instanceof RuntimeException) {
                throw (RuntimeException)target;
            }
            throw new IllegalArgumentException("\u65b9\u6cd5\u8c03\u7528\u5931\u8d25", e);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new IllegalArgumentException("\u65b9\u6cd5\u8c03\u7528\u5931\u8d25", e);
        }
        if (returnVal == null) {
            return null;
        }
        if (returnVal instanceof WeforwardResource) {
            WeforwardResource r = (WeforwardResource)returnVal;
            response.setResourceId(r.getId());
            response.setResourceExpire(r.getExpire());
            response.setResourceService(r.getService());
            response.setResourceServiceNo(r.getServiceNo());
            response.setResourceUrl(r.getUrl());
            returnVal = r.getData();
        }
        if (returnVal instanceof DtBase) {
            return (DtBase)returnVal;
        }
        if (returnVal instanceof ResultPage) {
            Integer page;
            ResultPage rp = (ResultPage)returnVal;
            Integer pageSize = DocPageParams.tryGetInteger(params, "page_size");
            if (pageSize != null && pageSize > 0) {
                rp.setPageSize(pageSize.intValue());
            }
            if ((page = DocPageParams.tryGetInteger(params, "page")) != null) {
                rp.gotoPage(page.intValue());
            } else {
                rp.gotoPage(1);
            }
            returnVal = new PageData(rp);
        }
        DtBase result = MappedUtil.toBase((Object)returnVal, (ObjectMapperSet)this.m_ObjectMapperSet);
        if (returnVal instanceof AutoCloseable) {
            try {
                ((AutoCloseable)returnVal).close();
            }
            catch (Exception e) {
                _Logger.warn("\u5ffd\u7565\u5173\u95ed\u5f02\u5e38", (Throwable)e);
            }
        }
        return result;
    }

    private Throwable exception(Throwable target) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (this.m_Methods instanceof ExceptionHandler) {
            target = ((ExceptionHandler)this.m_Methods).exception(target);
        }
        if (this.m_Exceptions != null) {
            for (Method m : this.m_Exceptions) {
                Class<?> param;
                Class<?>[] params = m.getParameterTypes();
                if (params == null || params.length != 1 || !(param = params[0]).isAssignableFrom(target.getClass())) continue;
                Class<?> returnType = m.getReturnType();
                if (returnType == Void.TYPE) {
                    m.invoke(this.m_Methods, target);
                    continue;
                }
                target = (Throwable)m.invoke(this.m_Methods, target);
            }
        }
        return target;
    }

    private Object[] newArgs(String path, DtObject params, Request request, Response response, Class<?>[] types, Object ... objects) {
        if (types == null) {
            return null;
        }
        Object[] args = new Object[types.length];
        int i = 0;
        while (i < args.length) {
            Class<?> clazz = types[i];
            if (objects != null) {
                Object match = null;
                Object[] objectArray = objects;
                int n = objects.length;
                int n2 = 0;
                while (n2 < n) {
                    Object val = objectArray[n2];
                    if (val != null && val.getClass().isAssignableFrom(clazz)) {
                        match = val;
                        break;
                    }
                    ++n2;
                }
                if (match != null) {
                    args[i] = match;
                    break;
                }
            }
            if (FriendlyObject.class.isAssignableFrom(clazz)) {
                args[i] = new FriendlyObject(params);
            } else if (DtObject.class.isAssignableFrom(clazz)) {
                args[i] = params;
            } else if (Header.class.isAssignableFrom(clazz)) {
                args[i] = request.getHeader();
            } else if (String.class.isAssignableFrom(clazz)) {
                args[i] = path;
            } else if (Request.class.isAssignableFrom(clazz)) {
                args[i] = request;
            } else if (Response.class.isAssignableFrom(clazz)) {
                args[i] = response;
            } else {
                boolean accept = false;
                for (ArgsProvider p : this.m_ArgsProviders) {
                    if (p == null || !p.accept(clazz)) continue;
                    args[i] = p.create(params, clazz);
                    accept = true;
                    break;
                }
                if (!accept) {
                    args[i] = MappedUtil.fromBase(clazz, null, (DtBase)params, (ObjectMapperSet)this.m_ObjectMapperSet);
                }
            }
            ++i;
        }
        return args;
    }

    protected Object beforeInvoke(String path, DtObject params, Request request, Response response) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        DtObject v = null;
        for (ArgsProvider p : this.m_ArgsProviders) {
            p.before(params);
        }
        if (this.m_Befores != null) {
            for (Method m : this.m_Befores) {
                if (m.getReturnType() == Void.TYPE) {
                    m.invoke(this.m_Methods, this.newArgs(path, params, request, response, null, m.getParameterTypes(), v));
                    continue;
                }
                v = (DtObject)m.invoke(this.m_Methods, this.newArgs(path, params, request, response, null, m.getParameterTypes(), v));
            }
        }
        return v;
    }

    protected Object afterInvoker(String path, DtObject params, Request request, Response response, Object returnVal) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Object v = returnVal;
        if (this.m_Afters != null) {
            for (Method m : this.m_Afters) {
                if (m.getReturnType() == Void.TYPE) {
                    m.invoke(this.m_Methods, this.newArgs(path, params, request, response, m.getParameterTypes(), returnVal));
                    continue;
                }
                v = m.invoke(this.m_Methods, this.newArgs(path, params, request, response, m.getParameterTypes(), returnVal));
            }
        }
        for (ArgsProvider p : this.m_ArgsProviders) {
            p.after(v);
        }
        return v;
    }

    Class<?> getMethods() {
        return this.m_Methods.getClass();
    }

    Method getMethod() {
        return this.m_Method;
    }

    @Override
    public boolean isAllow(WeforwardSession session) {
        if (this.m_AllowRoles != null) {
            User user = session.getOperator();
            return ReflectMethod.include(user.getRoles(), this.m_AllowRoles);
        }
        if (this.m_DisallowRoles != null) {
            User user = session.getOperator();
            return !ReflectMethod.include(user.getRoles(), this.m_DisallowRoles);
        }
        return true;
    }

    private static boolean include(List<Role> roles, List<Integer> roleids) {
        for (Role role : roles) {
            for (int id : roleids) {
                if (role.getId() != id) continue;
                return true;
            }
        }
        return false;
    }
}

