/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.framework.ext;

import cn.weforward.common.Destroyable;
import cn.weforward.common.compiler.CompilerJavaUtil;
import cn.weforward.common.sys.Shutdown;
import cn.weforward.common.util.ClassUtil;
import cn.weforward.common.util.FileUtil;
import cn.weforward.common.util.StringUtil;
import cn.weforward.framework.ApiException;
import cn.weforward.framework.InnerApiMethod;
import cn.weforward.framework.debug.VersionScript;
import cn.weforward.framework.ext.WeforwardService;
import cn.weforward.framework.support.AbstractApiMethod;
import cn.weforward.protocol.Request;
import cn.weforward.protocol.Response;
import cn.weforward.protocol.datatype.DtBase;
import cn.weforward.protocol.datatype.DtObject;
import cn.weforward.protocol.datatype.DtString;
import cn.weforward.protocol.support.datatype.FriendlyObject;
import cn.weforward.protocol.support.datatype.SimpleDtObject;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class DebugMethod
extends AbstractApiMethod
implements InnerApiMethod,
ApplicationContextAware,
Destroyable {
    private static final Logger _Logger = LoggerFactory.getLogger(DebugMethod.class);
    protected final File m_ClassTmp = new File(FileUtil.getAbsolutePath((String)"weforward_debug_class", (String)System.getProperty("java.io.tmpdir")));
    protected final File m_JavaTmp;
    protected ApplicationContext m_ApplicationContext;
    protected static final String INNER_SCRIPT_TAG = "_";
    protected static final String INNER_PACKAGE = String.valueOf(VersionScript.class.getPackage().getName()) + '.';

    public DebugMethod(WeforwardService service) {
        this(service, null);
    }

    public DebugMethod(WeforwardService service, String bashPath) {
        this(service, bashPath, "GW");
    }

    public DebugMethod(WeforwardService service, String bashPath, String kind) {
        super(String.valueOf(StringUtil.toString((Object)bashPath)) + "_debug", kind);
        if (!this.m_ClassTmp.exists()) {
            this.m_ClassTmp.mkdirs();
        }
        this.m_JavaTmp = new File(FileUtil.getAbsolutePath((String)"weforward_debug_java", (String)System.getProperty("java.io.tmpdir")));
        if (!this.m_JavaTmp.exists()) {
            this.m_JavaTmp.mkdirs();
        }
        service.registerMethod(this);
        Shutdown.register((Destroyable)this);
    }

    public DtObject handle(String path, DtObject params, Request request, Response response) throws ApiException {
        URLClassLoader loader = null;
        try {
            Class<?> clazzObj;
            try {
                loader = new URLClassLoader(new URL[]{this.m_ClassTmp.toURI().toURL()}, ClassUtil.getDefaultClassLoader());
            }
            catch (MalformedURLException e) {
                throw new ApiException(30001, "\u521b\u5efaloader\u5f02\u5e38\uff0c" + e.getMessage(), e);
            }
            FriendlyObject myparams = FriendlyObject.valueOf((DtObject)params);
            String name = myparams.getString("name");
            String src = myparams.getString("src");
            if (!StringUtil.isEmpty((String)name)) {
                if (name.startsWith(INNER_SCRIPT_TAG)) {
                    String fullclazzName = name.replace(INNER_SCRIPT_TAG, INNER_PACKAGE);
                    try {
                        clazzObj = Class.forName(fullclazzName);
                    }
                    catch (ClassNotFoundException e) {
                        throw new ApiException(30001, "\u52a0\u8f7d\u5f02\u5e38\uff0c\u627e\u4e0d\u5230" + fullclazzName + "\u7c7b", e);
                    }
                } else {
                    File java = new File(this.m_JavaTmp, String.valueOf(name) + ".java");
                    if (!java.exists()) {
                        try {
                            clazzObj = Class.forName(name);
                        }
                        catch (ClassNotFoundException e) {
                            throw new ApiException(20001, "\u4e0d\u5b58\u5728" + name + "\u811a\u672c");
                        }
                    } else {
                        this.complier(java);
                        String fullclazzName = String.valueOf(DebugMethod.readPackage(java)) + name;
                        clazzObj = this.loadClass(loader, fullclazzName);
                    }
                }
            } else if (!StringUtil.isEmpty((String)src)) {
                name = this.readClass(src);
                File java = new File(this.m_JavaTmp, String.valueOf(name) + ".java");
                this.createSrc(java, src);
                this.complier(java);
                String fullclazzName = String.valueOf(this.readPackage(src)) + name;
                clazzObj = this.loadClass(loader, fullclazzName);
            } else {
                throw new ApiException(20001, "\u7f3a\u5c11name\u6216src\u53c2\u6570");
            }
            DtObject dtObject = this.doHandle(clazzObj, path, params);
            return dtObject;
        }
        finally {
            if (loader != null) {
                try {
                    loader.close();
                }
                catch (IOException e) {
                    _Logger.warn("\u5ffd\u7565\u5173\u95ed\u5f02\u5e38", (Throwable)e);
                }
            }
        }
    }

    protected DtObject doHandle(Class<?> clazzObj, String path, DtObject params) throws ApiException {
        Object back;
        Method m;
        Object v;
        try {
            v = clazzObj.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new ApiException(30001, "\u6784\u9020\u5f02\u5e38\uff1a" + e.getMessage(), e);
        }
        try {
            m = clazzObj.getMethod("handle", ApplicationContext.class, String.class, FriendlyObject.class);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new ApiException(30001, "\u83b7\u53d6\u65b9\u6cd5\u5f02\u5e38\uff1a" + e.getMessage(), e);
        }
        try {
            DtBase args = params.getAttribute("args");
            back = m.invoke(v, this.m_ApplicationContext, path, DebugMethod.valueOf(args));
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new ApiException(30001, "\u8c03\u7528\u65b9\u6cd5\u5f02\u5e38\uff1a" + e.getMessage());
        }
        return (DtObject)back;
    }

    protected static FriendlyObject valueOf(DtBase args) {
        if (args instanceof DtObject) {
            return FriendlyObject.valueOf((DtObject)((DtObject)args));
        }
        if (args instanceof DtString) {
            String v = ((DtString)args).value();
            String[] arr = v.split("&");
            SimpleDtObject params = new SimpleDtObject();
            String[] stringArray = arr;
            int n = arr.length;
            int n2 = 0;
            while (n2 < n) {
                String child = stringArray[n2];
                int index = child.indexOf(61);
                if (index >= 0) {
                    params.put(child.substring(0, index), child.substring(index + 1));
                }
                ++n2;
            }
            return FriendlyObject.valueOf((DtObject)params);
        }
        return FriendlyObject.valueOf(null);
    }

    protected void createSrc(File src, String content) throws ApiException {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (FileOutputStream out = new FileOutputStream(src);){
                out.write(content.getBytes());
                out.flush();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new ApiException(30001, "\u5199\u5165\u6e90\u6587\u4ef6\u51fa\u9519:" + e.getMessage(), e);
        }
    }

    protected void complier(File src) throws ApiException {
        DiagnosticCollector diagnostics = new DiagnosticCollector();
        try {
            if (!CompilerJavaUtil.complier((File)src, (File)this.m_ClassTmp, diagnostics)) {
                throw new ApiException(30001, "\u7f16\u8bd1\u5931\u8d25");
            }
            StringBuilder sb = new StringBuilder();
            for (Diagnostic diagnostic : diagnostics.getDiagnostics()) {
                sb.append("Code: " + diagnostic.getCode() + "  Kind: " + (Object)((Object)diagnostic.getKind()) + "  Position: " + diagnostic.getPosition() + "  Line Number:" + diagnostic.getLineNumber() + "  Column Number: " + diagnostic.getColumnNumber() + "  Source: " + diagnostic.getSource() + "  Message: " + diagnostic.getMessage(null));
                sb.append("\n");
            }
            if (!StringUtil.isEmpty((String)sb.toString())) {
                _Logger.warn("\u7f16\u8bd1\u5f02\u5e38," + sb.toString());
            }
        }
        catch (IOException e) {
            throw new ApiException(30001, "\u7f16\u8bd1\u5f02\u5e38", e);
        }
    }

    protected Class<?> loadClass(URLClassLoader loader, String clazz) throws ApiException {
        try {
            return loader.loadClass(clazz);
        }
        catch (ClassNotFoundException e) {
            throw new ApiException(30001, "\u52a0\u8f7d\u5f02\u5e38\uff0c\u627e\u4e0d\u5230" + clazz + "\u7c7b", e);
        }
    }

    protected static String readPackage(File file) {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            String line = reader.readLine();
            while (line != null) {
                if (line.startsWith("package")) {
                    String string = String.valueOf(line.substring(8, line.length() - 1)) + ".";
                    return string;
                }
                try {
                    line = reader.readLine();
                    continue;
                }
                catch (IOException e) {
                    _Logger.warn("\u8bfb\u53d6\u5f02\u5e38", (Throwable)e);
                }
                break;
            }
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {
                _Logger.warn("\u5ffd\u7565\u5f02\u5e38", (Throwable)e);
            }
        }
        return "";
    }

    protected String readClass(String content) {
        String tag = "public class ";
        int start = content.indexOf(tag) + tag.length();
        int end = content.indexOf(" ", start + 1);
        return content.substring(start, end);
    }

    protected String readPackage(String content) {
        String tag = "package ";
        int index = content.indexOf(tag);
        if (index < 0) {
            return "";
        }
        int start = index + tag.length();
        int end = content.indexOf(";", start + 1);
        return String.valueOf(content.substring(start, end)) + ".";
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.m_ApplicationContext = applicationContext;
    }

    public void destroy() {
        try {
            CompilerJavaUtil.delete((File)this.m_ClassTmp);
            CompilerJavaUtil.delete((File)this.m_JavaTmp);
        }
        catch (IOException e) {
            _Logger.warn("\u5ffd\u7565\u6e05\u7406\u5f02\u5e38", (Throwable)e);
        }
    }
}

