/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.framework;

import cn.weforward.protocol.ops.User;
import java.util.function.Supplier;

public interface WeforwardSession {
    public static final ThreadSession TLS = new ThreadSession();

    public String getAccessId();

    public String getIp();

    public void bindOperator(User var1);

    public void bindOperator(Supplier<User> var1);

    public User getOperator();

    public String getTenant();

    public String getOpenid();

    public <E extends User> E getUser();

    public boolean isSupportForward();

    public static class ThreadSession {
        private ThreadLocal<WeforwardSession> m_Session;

        public WeforwardSession putSession(WeforwardSession session) {
            WeforwardSession old;
            if (session == null) {
                if (this.m_Session == null) {
                    return null;
                }
                WeforwardSession old2 = this.m_Session.get();
                this.m_Session.set(session);
                return old2;
            }
            if (this.m_Session == null) {
                this.m_Session = new ThreadLocal();
                old = null;
            } else {
                old = this.m_Session.get();
            }
            this.m_Session.set(session);
            return old;
        }

        public WeforwardSession getSession() {
            return this.m_Session == null ? null : this.m_Session.get();
        }

        public String getIp() {
            WeforwardSession s = this.getSession();
            return s == null ? null : s.getIp();
        }

        public User getOperator() {
            return this.getUser();
        }

        public <E extends User> E getUser() {
            WeforwardSession s = this.getSession();
            return s == null ? null : (E)s.getUser();
        }

        public String getTenant() {
            WeforwardSession s = this.getSession();
            return s == null ? null : s.getTenant();
        }

        public String getOpenid() {
            WeforwardSession s = this.getSession();
            return s == null ? null : s.getOpenid();
        }

        public boolean isSupportForward() {
            WeforwardSession s = this.getSession();
            return s == null ? false : s.isSupportForward();
        }
    }
}

