/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.boot;

import cn.weforward.boot.CloudLoader;
import cn.weforward.common.util.StringUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.springframework.core.io.ClassPathResource;

public class CloudPropertyPlaceholderConfigurer
extends PropertyPlaceholderConfigurer {
    static final Logger _Logger = LoggerFactory.getLogger(CloudPropertyPlaceholderConfigurer.class);
    boolean m_DisableCloud = false;
    boolean m_DisableCloudCache = false;
    protected String m_CloudCachePath = null;
    private static final String CLOUD_CONFIG_DISABLE = "cloud.disable";
    private static final String CLOUD_CONFIG_CACHE_DISABLE = "cloud.cache.disable";
    private static final String CLOUD_CONFIG_CACHE_PATH = "cloud.cache.path";
    private static final String DEV_KEY = "weforward-dev.properties";
    private static final String TEST_PROP_KEY = "weforward-test.properties";
    private static final String PROP_KEY = "weforward.properties";
    private CloudLoader m_CloudLoader = new CloudLoader();

    public CloudPropertyPlaceholderConfigurer() {
        this.setDisableCloud("true".equalsIgnoreCase(System.getProperty(CLOUD_CONFIG_DISABLE)));
        this.setDisableCloudCache("true".equalsIgnoreCase(System.getProperty(CLOUD_CONFIG_CACHE_DISABLE)));
        String path = System.getProperty(CLOUD_CONFIG_CACHE_PATH);
        if (StringUtil.isEmpty((String)path)) {
            path = String.valueOf(System.getProperty("user.dir")) + File.separator + "config" + File.separator + File.separator;
        }
    }

    public void setDisableCloud(boolean disable) {
        this.m_DisableCloud = disable;
    }

    public void setDisableCloudCache(boolean disable) {
        this.m_DisableCloudCache = disable;
    }

    protected Properties mergeProperties() throws IOException {
        Properties result = super.mergeProperties();
        try {
            result = CloudPropertyPlaceholderConfigurer.load(result, DEV_KEY);
        }
        catch (Throwable e) {
            throw new IllegalArgumentException("\u83b7\u53d6\u914d\u7f6e\u5931\u8d25:" + e.getMessage(), e);
        }
        try {
            result = CloudPropertyPlaceholderConfigurer.load(result, TEST_PROP_KEY);
        }
        catch (Throwable e) {
            throw new IllegalArgumentException("\u83b7\u53d6\u914d\u7f6e\u5931\u8d25:" + e.getMessage(), e);
        }
        try {
            result = CloudPropertyPlaceholderConfigurer.load(result, PROP_KEY);
        }
        catch (Throwable e) {
            throw new IllegalArgumentException("\u83b7\u53d6\u914d\u7f6e\u5931\u8d25:" + e.getMessage(), e);
        }
        if (!this.m_DisableCloud) {
            Properties cloudresult;
            block12: {
                cloudresult = null;
                try {
                    cloudresult = this.m_CloudLoader.load(result);
                    if (!this.m_DisableCloudCache) {
                        this.updateCloudCache(result);
                    }
                }
                catch (RuntimeException e) {
                    if (!this.m_DisableCloudCache) {
                        _Logger.warn("\u52a0\u8f7d\u4e91\u914d\u7f6e\u5931\u8d25\uff0c\u4f7f\u7528\u672c\u5730\u7f13\u5b58", (Throwable)e);
                        cloudresult = this.loadCloudCache();
                    }
                    if (cloudresult != null) break block12;
                    _Logger.warn("\u672a\u627e\u5230\u672c\u5730\u7f13\u5b58");
                    throw e;
                }
            }
            for (Map.Entry<Object, Object> e : cloudresult.entrySet()) {
                result.putIfAbsent(e.getKey(), e.getValue());
            }
        }
        return result;
    }

    private File getCloudCacheFile() {
        File path = new File(this.m_CloudCachePath);
        if (!path.exists()) {
            path.mkdirs();
        }
        return new File(path, "cloud.properties");
    }

    private Properties loadCloudCache() throws IOException {
        File file = this.getCloudCacheFile();
        if (!file.exists()) {
            return null;
        }
        Throwable throwable = null;
        Object var3_5 = null;
        try (BufferedReader read = new BufferedReader(new FileReader(file));){
            String line;
            Properties result = new Properties();
            while ((line = read.readLine()) != null) {
                int index = line.indexOf(61);
                String key = line.substring(0, index);
                String value = line.substring(index + 1);
                result.put(key, value);
            }
            return result;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void updateCloudCache(Properties result) throws IOException {
        File file = this.getCloudCacheFile();
        Throwable throwable = null;
        Object var4_6 = null;
        try (BufferedWriter out = new BufferedWriter(new FileWriter(file));){
            for (Map.Entry<Object, Object> e : result.entrySet()) {
                out.write(String.valueOf(StringUtil.toString((Object)e.getKey())) + "=" + StringUtil.toString((Object)e.getValue()));
                out.newLine();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected void loadProperties(Properties props) throws IOException {
        try {
            super.loadProperties(props);
        }
        catch (FileNotFoundException e) {
            _Logger.warn("\u5ffd\u7565\u627e\u4e0d\u5230\u6587\u4ef6\u5f02\u5e38:" + e.getMessage());
        }
    }

    private static Properties load(Properties result, String propkey) throws IOException {
        ClassPathResource res = new ClassPathResource(propkey);
        if (res.exists()) {
            _Logger.info("load " + propkey);
            Properties prop = new Properties();
            prop.load(res.getInputStream());
            for (Map.Entry<Object, Object> e : prop.entrySet()) {
                String key = StringUtil.toString((Object)e.getKey());
                if (result.get(key) != null || System.getProperty(key) != null) continue;
                String value = StringUtil.toString((Object)e.getValue());
                result.put(key, value);
            }
        }
        return result;
    }
}

