/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.boot;

import cn.weforward.common.util.StringUtil;
import cn.weforward.framework.ApiException;
import cn.weforward.protocol.Response;
import cn.weforward.protocol.client.ServiceInvoker;
import cn.weforward.protocol.client.ServiceInvokerFactory;
import cn.weforward.protocol.datatype.DtObject;
import cn.weforward.protocol.support.datatype.FriendlyList;
import cn.weforward.protocol.support.datatype.FriendlyObject;
import cn.weforward.protocol.support.datatype.SimpleDtObject;
import java.io.IOException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudLoader {
    static final Logger _Logger = LoggerFactory.getLogger(CloudLoader.class);
    String m_Serverid = System.getProperty("weforward.serverid");
    String m_ProjectName = System.getProperty("project_name");
    String m_CloudConfigServiceName = "devops";
    String m_CloudConfigMethodName = "/devops/config/serviceprops";
    ServiceInvoker m_Invoker;
    String m_ApiUrl;
    String m_AccessId;
    String m_AccessKey;
    private static final String CLOUD_CONFIG_SERVICENAME_KEY = "cloud.config.servicename";
    private static final String CLOUD_CONFIG_METHODNAME_KEY = "cloud.config.methodname";
    public static final String PROJECT_NAME_KEY = "project_name";
    public static final String APIURL_KEY = "weforward.apiUrl";
    public static final String ACCESSID_KEY = "weforward.service.accessId";
    public static final String ACCESSKEY_KEY = "weforward.service.accessKey";

    public CloudLoader() {
        String methodName;
        String serviceName = System.getProperty(CLOUD_CONFIG_SERVICENAME_KEY);
        if (!StringUtil.isEmpty((String)serviceName)) {
            this.m_CloudConfigServiceName = serviceName;
        }
        if (!StringUtil.isEmpty((String)(methodName = System.getProperty(CLOUD_CONFIG_METHODNAME_KEY)))) {
            this.m_CloudConfigMethodName = methodName;
        }
        this.m_ApiUrl = System.getProperty(APIURL_KEY);
        this.m_AccessId = System.getProperty(ACCESSID_KEY);
        this.m_AccessKey = System.getProperty(ACCESSKEY_KEY);
    }

    public Properties load(Properties config) throws IOException {
        ServiceInvoker invoker;
        if (StringUtil.isEmpty((String)this.m_ProjectName)) {
            this.m_ProjectName = config.getProperty(PROJECT_NAME_KEY);
        }
        if (StringUtil.isEmpty((String)this.m_ApiUrl)) {
            this.m_ApiUrl = config.getProperty(APIURL_KEY);
        }
        if (StringUtil.isEmpty((String)this.m_AccessId)) {
            this.m_AccessId = config.getProperty(ACCESSID_KEY);
        }
        if (StringUtil.isEmpty((String)this.m_AccessKey)) {
            this.m_AccessKey = config.getProperty(ACCESSKEY_KEY);
        }
        if ((invoker = this.getInvoker()) != null) {
            try {
                return this.load(invoker, this.m_ProjectName, this.m_Serverid);
            }
            catch (Throwable e) {
                throw new IllegalArgumentException("\u83b7\u53d6\u914d\u7f6e\u5931\u8d25:" + e.getMessage(), e);
            }
        }
        return new Properties();
    }

    private ServiceInvoker getInvoker() throws IOException {
        if (this.m_Invoker == null) {
            if (StringUtil.isEmpty((String)this.m_ApiUrl)) {
                _Logger.warn("\u672a\u914d\u7f6eweforward.apiUrl");
                return null;
            }
            if (StringUtil.isEmpty((String)this.m_AccessId) && StringUtil.isEmpty((String)this.m_AccessKey)) {
                _Logger.warn("\u672a\u914d\u7f6eweforward.service.accessId\u548cweforward.service.accessKey");
                return null;
            }
            if (StringUtil.isEmpty((String)this.m_AccessId) || StringUtil.isEmpty((String)this.m_AccessKey)) {
                throw new IllegalArgumentException("\u672a\u914d\u7f6eweforward.service.accessId\u6216weforward.service.accessKey");
            }
            this.m_Invoker = ServiceInvokerFactory.create((String)this.m_CloudConfigServiceName, (String)this.m_ApiUrl, (String)this.m_AccessId, (String)this.m_AccessKey);
        }
        return this.m_Invoker;
    }

    private Properties load(ServiceInvoker invoker, String name, String sid) throws ApiException {
        SimpleDtObject params = new SimpleDtObject();
        params.put("projectName", name);
        params.put("serverid", sid);
        Response response = invoker.invoke(this.m_CloudConfigMethodName, (DtObject)params);
        if (response.getResponseCode() != 0) {
            throw new ApiException(30001, "\u7f51\u5173\u54cd\u5e94\u5f02\u5e38\uff1a" + response.getResponseMsg());
        }
        FriendlyObject hyresult = FriendlyObject.valueOf((DtObject)response.getServiceResult());
        int code = hyresult.getInt("code");
        if (code != 0) {
            throw new ApiException(30001, "\u4e1a\u52a1\u5f02\u5e38\uff1a" + hyresult.getString("msg"));
        }
        Properties result = new Properties();
        FriendlyList content = hyresult.getFriendlyList("content");
        int i = 0;
        while (i < content.size()) {
            FriendlyObject item = content.getFriendlyObject(i);
            String key = item.getString("key");
            String value = item.getString("value");
            result.put(key, StringUtil.toString((Object)value));
            ++i;
        }
        return result;
    }
}

