package cn.virens.common.web;

import org.springframework.ui.Model;

import cn.hutool.core.util.StrUtil;
import cn.virens.common.exception.ExceptionUtil;

/**
 * 通用控制器-JSON
 * 
 * @author virens
 */
public class BaseJSONController extends BaseController {
	protected BaseJSONController() {
		super(StrUtil.EMPTY);
	}

	/**
	 * @param baseTemplateUrl 模板根路径
	 */
	protected BaseJSONController(String baseTemplateUrl) {
		super(baseTemplateUrl);
	}

	protected final Model renderSuccess(Object data, Model model, String message) {
		model.addAttribute("message", message);
		model.addAttribute("code", "SUCCESS");
		model.addAttribute("data", data);
		return model;
	}

	protected final Model renderSuccess(Model model, String message) {
		model.addAttribute("message", message);
		model.addAttribute("code", "SUCCESS");

		return model;
	}

	protected final Model renderSuccess(Object data, Model model) {
		model.addAttribute("code", "SUCCESS");
		model.addAttribute("data", data);

		return model;
	}

	protected final Model renderSuccess(Model model) {
		model.addAttribute("code", "SUCCESS");

		return model;
	}

	protected final Model renderFail(Model model, String code, String message) {
		model.addAttribute("message", message);
		model.addAttribute("code", code);
		return model;
	}

	protected final Model renderFail(Model model, Throwable ex) {
		model.addAttribute("message", ExceptionUtil.getMessage(ex));
		model.addAttribute("code", ExceptionUtil.getCode(ex));

		return model;
	}

	protected final Model renderFail(Model model, String message) {
		model.addAttribute("message", message);
		return model;
	}

	protected final Model renderFail(Model model) {
		model.addAttribute("code", "FAIL");

		return model;
	}
}
