package cn.virens.common.apifox.util;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ValueConstants;

import cn.hutool.core.util.StrUtil;
import cn.virens.common.apifox.ApifoxType;
import cn.virens.common.apifox.build.ApiFoxCollectionParamItem;
import cn.virens.common.exception.APIException;

public class ApifoxUtilParam {
	/** 获取请求参数 */
	public static List<ApiFoxCollectionParamItem> getParamItem(Method method) throws APIException {
		return Arrays.stream(method.getParameters()).map(parameter -> {
			RequestParam param = parameter.getAnnotation(RequestParam.class);
			if (param == null || StrUtil.isEmpty(name(param))) return null;

			ApiFoxCollectionParamItem item = new ApiFoxCollectionParamItem();
			item.setType(ApifoxType.formatType(parameter.getType()));
			item.setRequired(param.required());
			item.setExample(value(param));
			item.setName(name(param));

			return item;
		}).filter(a -> a != null).collect(Collectors.toList());
	}

	private static String value(RequestParam rp) throws APIException {
		if (!ValueConstants.DEFAULT_NONE.equals(rp.defaultValue())) {
			return rp.defaultValue();
		} else {
			return "";
		}
	}

	private static String name(RequestParam rp) throws APIException {
		if (StrUtil.isNotEmpty(rp.value())) {
			return rp.value();
		} else {
			return rp.name();
		}
	}
}
