package cn.virens.common.apifox.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;

import org.springframework.web.bind.annotation.RequestBody;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.annotation.JSONField;

import cn.hutool.core.util.ReflectUtil;
import cn.virens.common.apifox.ApifoxType;
import cn.virens.common.apifox.build.ApiFoxCollectionRequestJson;
import cn.virens.common.exception.APIException;
import io.mybatis.provider.Entity.Column;

public class ApifoxUtilBody {
	/** 获取请求对象 */
	public static ApiFoxCollectionRequestJson getRequest(Method method) throws APIException {
		return Arrays.stream(method.getParameters()).filter(parameters -> {
			return parameters.getAnnotation(RequestBody.class) != null;
		}).findAny().map(m -> parse(m.getType())).orElse(null);
	}

	private static ApiFoxCollectionRequestJson parse(Class<?> clazz) throws APIException {
		if (clazz == null || Collection.class.isAssignableFrom(clazz)) return null;
		if (clazz == null || JSON.class.isAssignableFrom(clazz)) return null;
		if (clazz == null || Map.class.isAssignableFrom(clazz)) return null;

		ApiFoxCollectionRequestJson schema = new ApiFoxCollectionRequestJson();
		schema.setType("object");

		Arrays.stream(ReflectUtil.getFields(clazz)).forEach(field -> {
			ApiFoxCollectionRequestJson temp = new ApiFoxCollectionRequestJson();
			temp.setType(ApifoxType.formatType(field.getType()));
			temp.setTitle(getTitle(field));

			schema.addProperties(getName(field), temp);
		});

		return schema;
	}

	private static String getName(Field field) throws APIException {
		JSONField anno = field.getAnnotation(JSONField.class);
		if (anno == null || anno.name() == null) {
			return field.getName();
		} else {
			return anno.name();
		}
	}

	private static String getTitle(Field field) throws APIException {
		Column anno = field.getAnnotation(Column.class);
		if (anno == null || anno.remark() == null) {
			return field.getName();
		} else {
			return anno.remark();
		}
	}
}
