package cn.virens.common.apifox.util;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Optional;

import cn.hutool.core.collection.CollUtil;
import cn.virens.common.apifox.build.ApiFoxCollection;
import cn.virens.common.apifox.build.ApiFoxCollectionParam;
import cn.virens.common.apifox.build.ApiFoxCollectionParamItem;
import cn.virens.common.apifox.build.ApiFoxCollectionRequest;

public class ApifoxUtil {
	/** 填充注解(参数，请求体) */
	public static ApiFoxCollection fill(Method method, ApiFoxCollection api) {
		api.getApi().setRequestBody(request(method, api.getApi().getRequestBody()));
		api.getApi().setParameters(param0(method, api.getApi().getParameters()));

		return api;
	}

	/** 处理请求实体对象 */
	private static ApiFoxCollectionRequest request(Method method, ApiFoxCollectionRequest request) {
		return Optional.ofNullable(request).or(ApifoxUtil::newRequest).map(temp -> {
			temp.setJsonSchema(ApifoxUtilBody.getRequest(method));
			temp.setType("application/json");

			return temp;
		}).orElse(null);
	}

	/** 处理注解请求参数 */
	private static ApiFoxCollectionParam param0(Method method, ApiFoxCollectionParam param) {
		return Optional.ofNullable(param).or(ApifoxUtil::newParam).map(temp -> {
			if (temp.getQuery() == null || temp.getQuery().isEmpty()) {
				temp.setQuery(new ArrayList<>());
			}

			return param1(method, temp);
		}).get();
	}

	private static ApiFoxCollectionParam param1(Method method, ApiFoxCollectionParam temp) {
		for (ApiFoxCollectionParamItem item : ApifoxUtilParam.getParamItem(method)) {
			if (!CollUtil.contains(temp.getQuery(), a -> a.equals(item))) {
				temp.getQuery().add(item);
			}
		}

		return temp;
	}

	private static Optional<ApiFoxCollectionRequest> newRequest() {
		return Optional.of(new ApiFoxCollectionRequest());
	}

	private static Optional<ApiFoxCollectionParam> newParam() {
		return Optional.of(new ApiFoxCollectionParam());
	}

}
