package cn.virens.common.apifox.build;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.alibaba.fastjson2.annotation.JSONField;

@SuppressWarnings("serial")
public class ApiFoxCollectionRequestJson implements Serializable {
	private Map<String, ApiFoxCollectionRequestJson> properties;

	@JSONField(name = "required")
	private List<String> apifoxRequired;

	@JSONField(name = "x-apifox-orders")
	private List<String> apifoxOrders;

	private String title;
	private String type;

	public Map<String, ApiFoxCollectionRequestJson> getProperties() {
		return properties;
	}

	public void setProperties(Map<String, ApiFoxCollectionRequestJson> properties) {
		this.properties = properties;
	}

	/** 添加一个属性 */
	public void addProperties(String name, ApiFoxCollectionRequestJson schema) {
		if (properties == null || properties.isEmpty()) {
			this.apifoxRequired = new ArrayList<>();
			this.apifoxOrders = new ArrayList<>();
			this.properties = new HashMap<>();
		}

		this.properties.put(name, schema);
		this.apifoxRequired.add(name);
		this.apifoxOrders.add(name);
	}

	public List<String> getApifoxRequired() {
		return apifoxRequired;
	}

	public void setApifoxRequired(List<String> apifoxRequired) {
		this.apifoxRequired = apifoxRequired;
	}

	public List<String> getApifoxOrders() {
		return apifoxOrders;
	}

	public void setApifoxOrders(List<String> apifoxOrders) {
		this.apifoxOrders = apifoxOrders;
	}

	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

}
