package cn.virens.common.apifox;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 用于生成Postman接口文档
 * 
 * @author virens
 */
@Target({ ElementType.TYPE, ElementType.METHOD })
@Retention(RetentionPolicy.RUNTIME)
public @interface ApifoxDoc {
	/** 接口名称 */
	String name() default "";

	/** 接口分组（/分割） */
	String group() default "";

	/** 接口描述 */
	String description() default "";

	/** 请求参数:参数名,类型,必填,示例值,说明(简化:参数名,示例值,说明) */
	String[] query() default {};

	/** 请求头:参数名,类型,必填,示例值,说明(简化:参数名,示例值,说明) */
	String[] header() default {};
}
