/*
 * Decompiled with CFR 0.152.
 */
package cn.structured.mybatis.plus.starter.provider;

import cn.hutool.core.util.StrUtil;
import cn.structured.mybatis.plus.starter.core.FieldJoinInfo;
import cn.structured.mybatis.plus.starter.core.JoinHelper;
import cn.structured.mybatis.plus.starter.core.JoinTableInfo;
import cn.structured.mybatis.plus.starter.core.QueryJoinPageListWrapper;
import com.baomidou.mybatisplus.core.metadata.TableFieldInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.extension.toolkit.SqlHelper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SelectJoinList {
    public String selectJoinList(HashMap condition) {
        QueryJoinPageListWrapper queryWrapper = (QueryJoinPageListWrapper)condition.get("wrapper");
        Object entity = queryWrapper.getEntity();
        boolean isJoin = queryWrapper.getIsJoin();
        TableInfo tableInfo = SqlHelper.table((Class)queryWrapper.getClazz());
        List<String> selectColumn = queryWrapper.getSelectColumn();
        StringBuilder sqlBuilder = new StringBuilder();
        JoinTableInfo joinTableInfo = JoinHelper.getTableInfo(queryWrapper.getClazz());
        sqlBuilder.append("<script> ");
        sqlBuilder.append("SELECT ");
        if (selectColumn.size() == 0) {
            String columns = JoinHelper.getColumns(joinTableInfo);
            sqlBuilder.append(columns);
        } else {
            selectColumn.forEach(column -> {
                if (column.indexOf(".") > 0) {
                    sqlBuilder.append((String)column);
                } else {
                    sqlBuilder.append(joinTableInfo.getTableName());
                    sqlBuilder.append(".");
                    sqlBuilder.append((String)column);
                    sqlBuilder.append(" as ");
                    sqlBuilder.append(StrUtil.toCamelCase((CharSequence)column));
                }
            });
        }
        Map<String, FieldJoinInfo> joinInfoList = joinTableInfo.getJoinInfo();
        if (isJoin) {
            joinInfoList.values().stream().forEach(joinInfoItem -> {
                String joinColumnsSql = JoinHelper.getJoinColumnsSql(joinInfoItem, queryWrapper.getJoinGroup());
                sqlBuilder.append(joinColumnsSql);
            });
        }
        sqlBuilder.append(" FROM ");
        sqlBuilder.append(joinTableInfo.getTableName());
        if (isJoin) {
            joinInfoList.values().stream().forEach(joinInfoItem -> {
                String joinSql = JoinHelper.getJoinSql(joinTableInfo, joinInfoItem, queryWrapper.getJoinGroup());
                sqlBuilder.append(" \n");
                sqlBuilder.append(joinSql);
            });
        }
        List<String> searchList = queryWrapper.getSearchList();
        List<String> timeList = queryWrapper.getTimeList();
        List fieldList = tableInfo.getFieldList();
        sqlBuilder.append("<trim prefix=\"where (\" suffix=\")\" suffixOverrides=\" AND \">");
        boolean withLogicDelete = tableInfo.isWithLogicDelete();
        if (withLogicDelete) {
            TableFieldInfo logicDeleteFieldInfo = tableInfo.getLogicDeleteFieldInfo();
            sqlBuilder.append(tableInfo.getTableName());
            sqlBuilder.append(".");
            sqlBuilder.append(logicDeleteFieldInfo.getColumn());
            sqlBuilder.append("=");
            sqlBuilder.append(logicDeleteFieldInfo.getLogicNotDeleteValue());
            sqlBuilder.append(" ");
        }
        sqlBuilder.append("<trim suffixOverrides=\" AND \">");
        sqlBuilder.append("<if test= 'wrapper.entity.");
        sqlBuilder.append(tableInfo.getKeyProperty());
        sqlBuilder.append("!= null' >\n");
        sqlBuilder.append(" AND \n");
        sqlBuilder.append(tableInfo.getTableName());
        sqlBuilder.append(".");
        sqlBuilder.append(tableInfo.getKeyColumn());
        sqlBuilder.append("=#{");
        sqlBuilder.append("wrapper.entity.");
        sqlBuilder.append(tableInfo.getKeyProperty());
        sqlBuilder.append("}");
        sqlBuilder.append("</if>");
        if (null != entity) {
            fieldList.stream().forEach(tableFieldInfo -> {
                StringBuilder sb = new StringBuilder();
                sb.append("<if test= '");
                sb.append("wrapper.entity.");
                sb.append(tableFieldInfo.getProperty());
                sb.append(" != null' >\n");
                sb.append(" AND \n");
                sb.append(tableInfo.getTableName());
                sb.append(".");
                sb.append(tableFieldInfo.getColumn());
                sb.append("=#{");
                sb.append("wrapper.entity.");
                sb.append(tableFieldInfo.getProperty());
                sb.append("}");
                sb.append("</if>");
                if (!searchList.contains(tableFieldInfo.getColumn()) && !timeList.contains(tableFieldInfo.getColumn())) {
                    sqlBuilder.append(sb.toString());
                }
            });
        }
        sqlBuilder.append("</trim>");
        sqlBuilder.append("<trim prefix=\" AND (\" suffix=\")\" suffixOverrides=\" OR \">");
        searchList.stream().forEach(searchStr -> {
            sqlBuilder.append("<if test=\" wrapper.search!=null and wrapper.search!=''\">");
            if (searchStr.indexOf(".") < 0) {
                sqlBuilder.append(tableInfo.getTableName());
                sqlBuilder.append(".");
            }
            sqlBuilder.append((String)searchStr);
            sqlBuilder.append(" LIKE CONCAT('%',#{wrapper.search},'%') OR ");
            sqlBuilder.append("</if>");
        });
        sqlBuilder.append("</trim>");
        sqlBuilder.append("<trim prefix=\" AND (\" suffix=\")\" suffixOverrides=\" OR \">");
        timeList.stream().filter(timeStr -> queryWrapper.getBeginTime() != null || queryWrapper.getEndTime() != null).forEach(timeStr -> {
            sqlBuilder.append("<trim prefix=\"(\" suffix=\")\" suffixOverrides=\" AND \">");
            sqlBuilder.append("<if test=\" wrapper.beginTime!=null \">\n");
            sqlBuilder.append("<![CDATA[ DATE_FORMAT(");
            if (timeStr.indexOf(".") < 0) {
                sqlBuilder.append(tableInfo.getTableName());
                sqlBuilder.append(".");
            }
            sqlBuilder.append((String)timeStr);
            sqlBuilder.append(", '%Y-%m-%d')>=  DATE_FORMAT(#{wrapper.beginTime}, '%Y-%m-%d')   ]]>\n");
            sqlBuilder.append(" AND \n");
            sqlBuilder.append("</if>");
            sqlBuilder.append("<if test=\" wrapper.endTime!=null \">\n");
            sqlBuilder.append("<![CDATA[ DATE_FORMAT(");
            if (timeStr.indexOf(".") < 0) {
                sqlBuilder.append(tableInfo.getTableName());
                sqlBuilder.append(".");
            }
            sqlBuilder.append((String)timeStr);
            sqlBuilder.append(", '%Y-%m-%d') <=  DATE_FORMAT(#{wrapper.endTime}, '%Y-%m-%d')   ]]>\n");
            sqlBuilder.append("</if>");
            sqlBuilder.append("</trim>");
            sqlBuilder.append(" OR ");
        });
        sqlBuilder.append("</trim>");
        if (StrUtil.isNotBlank((CharSequence)queryWrapper.getCondition())) {
            sqlBuilder.append(" AND ( ");
            sqlBuilder.append(queryWrapper.getCondition());
            sqlBuilder.append(")");
        }
        sqlBuilder.append("</trim>");
        sqlBuilder.append("</script> ");
        return sqlBuilder.toString();
    }
}

