/*
 * Decompiled with CFR 0.152.
 */
package cn.structured.mybatis.plus.starter.core;

import cn.hutool.core.util.StrUtil;
import cn.structured.mybatis.plus.starter.annotations.JoinCondition;
import cn.structured.mybatis.plus.starter.core.FieldJoinInfo;
import cn.structured.mybatis.plus.starter.core.JoinTableInfo;
import cn.structured.mybatis.plus.starter.enums.JoinResultEnum;
import cn.structured.mybatis.plus.starter.enums.JoinTypeEnum;
import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class JoinHelper {
    public static Map<Class, JoinTableInfo> joinTableInfoMap = new ConcurrentHashMap<Class, JoinTableInfo>();

    public static JoinTableInfo getTableInfo(Class clazz) {
        return joinTableInfoMap.get(clazz);
    }

    public static String getColumns(JoinTableInfo joinTableInfo) {
        String tableName = joinTableInfo.getTableName();
        ArrayList<String> columnList = new ArrayList<String>();
        columnList.add(tableName + "." + joinTableInfo.getPrimaryKey());
        columnList.addAll(joinTableInfo.getFieldList().stream().map(joinTableFieldInfo -> tableName + "." + joinTableFieldInfo.getColumn() + " AS " + joinTableFieldInfo.getProperty()).collect(Collectors.toList()));
        return StrUtil.join((CharSequence)",", (Object[])new Object[]{columnList});
    }

    public static String getJoinSql(JoinTableInfo joinTableInfo, FieldJoinInfo fieldJoinInfo, Class<?> group) {
        StringBuilder stringBuilder = new StringBuilder();
        fieldJoinInfo.getJoinInfoList().stream().filter(joinInfo -> group == null || joinInfo.getGroups().contains(group)).forEach(joinInfo -> {
            JoinTableInfo targetJoinTableInfo = joinTableInfoMap.get(joinInfo.getJoinTarget());
            String tableName = targetJoinTableInfo.getTableName();
            String currentTableName = joinTableInfo.getTableName();
            JoinTypeEnum joinType = joinInfo.getJoinType();
            stringBuilder.append(joinType.getKeyword());
            stringBuilder.append(" ");
            stringBuilder.append(targetJoinTableInfo.getTableName());
            if (!StrUtil.isBlank((CharSequence)joinInfo.getAliasName())) {
                stringBuilder.append(" ");
                stringBuilder.append(joinInfo.getAliasName());
            }
            stringBuilder.append(" ON ");
            List<JoinCondition> joinConditionInfo = joinInfo.getJoinConditionInfo();
            joinConditionInfo.stream().forEach(joinCondition -> {
                StringBuilder sb = new StringBuilder();
                sb.append(joinCondition.value());
                if (joinCondition.targetColumn().indexOf(".") < 0) {
                    if (!StrUtil.isBlank((CharSequence)joinInfo.getAliasName())) {
                        sb.append(joinInfo.getAliasName());
                    } else {
                        sb.append(tableName);
                    }
                    sb.append(".");
                }
                sb.append(joinCondition.targetColumn());
                sb.append(joinCondition.joinKeyword().getKeyword());
                if (joinCondition.currentColumn().indexOf(".") < 0) {
                    sb.append(currentTableName);
                    sb.append(".");
                }
                sb.append(joinCondition.currentColumn());
                stringBuilder.append(!StrUtil.isBlank((CharSequence)joinCondition.condition()) ? joinCondition.condition() : sb.toString());
            });
            stringBuilder.append(" \n ");
        });
        return stringBuilder.toString();
    }

    public static String getJoinColumnsSql(FieldJoinInfo fieldJoinInfo, Class<?> group) {
        StringBuilder columns = new StringBuilder();
        String resultName = fieldJoinInfo.getResultName();
        Class<?> result = fieldJoinInfo.getResult();
        boolean isObject = !result.equals(String.class) && !result.equals(Boolean.class) && !result.equals(Double.class) && !result.equals(Float.class) && !result.equals(Integer.class) && !result.equals(Long.class) && !result.equals(BigDecimal.class) && !result.equals(BigInteger.class) && !result.equals(Date.class) && !result.equals(LocalDateTime.class) && !result.equals(LocalTime.class) && !result.equals(LocalDate.class) && !result.equals(Byte.class) && !result.equals(Short.class) && !result.equals(Character.class);
        fieldJoinInfo.getJoinInfoList().stream().filter(joinInfo -> group == null || joinInfo.getGroups().contains(group)).forEach(joinInfo -> {
            Class<?> joinTarget = joinInfo.getJoinTarget();
            JoinTableInfo joinTableInfo = joinTableInfoMap.get(joinTarget);
            if (joinInfo.getColumns().size() <= 0 && joinInfo.getIsResult().booleanValue()) {
                joinTableInfo.getFieldList().stream().forEach(joinTableFieldInfo -> joinInfo.getColumns().add(joinTableFieldInfo.getColumn()));
            }
            joinInfo.getColumns().stream().forEach(column -> {
                columns.append(", ");
                if (!StrUtil.isBlank((CharSequence)joinInfo.getAliasName())) {
                    columns.append(joinInfo.getAliasName());
                } else {
                    columns.append(joinTableInfo.getTableName());
                }
                columns.append(".");
                columns.append((String)column);
                columns.append(" AS ");
                if (!StrUtil.isBlank((CharSequence)resultName)) {
                    columns.append(resultName);
                } else {
                    columns.append(StrUtil.toCamelCase((CharSequence)joinTableInfo.getTableName()));
                }
                if (isObject) {
                    columns.append("_");
                    columns.append(StrUtil.toCamelCase((CharSequence)column));
                }
            });
        });
        return columns.toString();
    }

    public static <R> List<R> getList(List<HashMap<String, Object>> records, Class<R> entityClass) {
        HashMap newResultMap = new HashMap();
        HashMap subListMap = new HashMap();
        HashMap subObjectMap = new HashMap();
        JoinTableInfo tableInfo = JoinHelper.getTableInfo(entityClass);
        Map<String, FieldJoinInfo> joinInfo = tableInfo.getJoinInfo();
        records.stream().forEach(stringObjectHashMap -> {
            HashMap newEntity = new HashMap();
            stringObjectHashMap.keySet().stream().filter(key -> key.indexOf("_") <= 0).forEach(key -> newEntity.put(key, stringObjectHashMap.get(key)));
            String hashCode = newEntity.hashCode() + "";
            if (!newResultMap.containsKey(hashCode)) {
                newResultMap.put(hashCode + "", newEntity);
            }
            stringObjectHashMap.keySet().stream().filter(key -> key.indexOf("_") > 0).forEach(key -> {
                String[] keys = key.split("_");
                String parent = keys[0];
                String sub = keys[1];
                if (joinInfo.containsKey(parent)) {
                    FieldJoinInfo fieldJoinInfo = (FieldJoinInfo)joinInfo.get(parent);
                    JoinResultEnum type = fieldJoinInfo.getType();
                    if (type.equals((Object)JoinResultEnum.MANY)) {
                        HashMap stringObjectMap = (HashMap)subListMap.get(hashCode + "_" + parent);
                        if (null == stringObjectMap) {
                            stringObjectMap = new HashMap();
                            subListMap.put(hashCode + "_" + parent, stringObjectMap);
                        }
                        stringObjectMap.put(JoinHelper.getNewKey(stringObjectMap, sub + "_0"), stringObjectHashMap.get(key));
                    } else {
                        HashMap stringObjectMap = (HashMap)subObjectMap.get(hashCode + "_" + parent);
                        if (null == stringObjectMap) {
                            stringObjectMap = new HashMap();
                            subObjectMap.put(hashCode + "_" + parent, stringObjectMap);
                        }
                        stringObjectMap.put(sub, stringObjectHashMap.get(key));
                    }
                }
            });
        });
        subObjectMap.keySet().stream().forEach(key -> {
            String[] keys = key.split("_");
            String hashCode = keys[0];
            String resultName = keys[1];
            Map obj = (Map)newResultMap.get(hashCode);
            FieldJoinInfo fieldJoinInfo = (FieldJoinInfo)joinInfo.get(resultName);
            Map stringObjectMap = (Map)subObjectMap.get(key);
            Object resultObj = JSONObject.parseObject((String)JSONObject.toJSONString((Object)stringObjectMap), fieldJoinInfo.getResult());
            obj.put(resultName, resultObj);
        });
        HashMap subObject = new HashMap();
        HashMap subListObject = new HashMap();
        subListMap.keySet().stream().forEach(key -> {
            String[] keys = key.split("_");
            String resultName = keys[1];
            ArrayList list = (ArrayList)subObject.get(key);
            if (null == list) {
                list = new ArrayList();
                subObject.put(key, list);
            }
            ArrayList arrList = list;
            subListObject.get(key);
            Map stringObjectMap = (Map)subListMap.get(key);
            stringObjectMap.keySet().stream().forEach(subKey -> {
                try {
                    String[] subKeys = subKey.split("_");
                    String fieldName = subKeys[0];
                    String number = subKeys[1];
                    Object subObj = subListObject.get(key + "_" + number);
                    if (null == subObj) {
                        subObj = ((FieldJoinInfo)joinInfo.get(resultName)).getResult().newInstance();
                        arrList.add(subObj);
                        subListObject.put(key + "_" + number, subObj);
                    }
                    Field declaredField = subObj.getClass().getDeclaredField(fieldName);
                    declaredField.setAccessible(true);
                    declaredField.set(subObj, stringObjectMap.get(subKey));
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                }
                catch (NoSuchFieldException e) {
                    e.printStackTrace();
                }
            });
        });
        for (String key2 : subObject.keySet()) {
            String[] keys = key2.split("_");
            String hashCode = keys[0];
            String resultName = keys[1];
            Map obj = (Map)newResultMap.get(hashCode);
            obj.put(resultName, subObject.get(key2));
        }
        return newResultMap.values().stream().map(map -> JSONObject.parseObject((String)JSONObject.toJSONString((Object)map), (Class)entityClass)).collect(Collectors.toList());
    }

    public static String getNewKey(Map map, String key) {
        if (map.containsKey(key)) {
            Integer num;
            Integer index = key.lastIndexOf("_") + 1;
            Integer n = num = Integer.valueOf(Integer.parseInt(key.substring(index)));
            Integer n2 = num = Integer.valueOf(num + 1);
            key = key.substring(0, index) + num;
            JoinHelper.getNewKey(map, key);
        }
        return key;
    }
}

