/*
 * Decompiled with CFR 0.152.
 */
package cn.structured.mybatis.plus.starter.configuration;

import cn.hutool.core.util.StrUtil;
import cn.structured.mybatis.plus.starter.annotations.DateTime;
import cn.structured.mybatis.plus.starter.annotations.FieldJoin;
import cn.structured.mybatis.plus.starter.annotations.Join;
import cn.structured.mybatis.plus.starter.annotations.Keyword;
import cn.structured.mybatis.plus.starter.core.FieldJoinInfo;
import cn.structured.mybatis.plus.starter.core.JoinHelper;
import cn.structured.mybatis.plus.starter.core.JoinInfo;
import cn.structured.mybatis.plus.starter.core.JoinTableFieldInfo;
import cn.structured.mybatis.plus.starter.core.JoinTableInfo;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.TableName;
import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.core.type.classreading.SimpleMetadataReaderFactory;
import org.springframework.util.ClassUtils;

public class JoinMyBatisPlusApplicationListener
implements ApplicationListener<ContextRefreshedEvent>,
ResourceLoaderAware {
    private static final Logger logger = LoggerFactory.getLogger(JoinMyBatisPlusApplicationListener.class);
    private MetadataReaderFactory metadataReaderFactory;

    public void onApplicationEvent(ContextRefreshedEvent contextRefreshedEvent) {
        Resource[] classResources;
        Map beansWithAnnotation = contextRefreshedEvent.getApplicationContext().getBeansWithAnnotation(SpringBootApplication.class);
        Optional any = beansWithAnnotation.values().stream().findAny();
        String packageName = "";
        if (any.isPresent()) {
            Object declaringClass = any.get();
            packageName = ClassUtils.getPackageName(declaringClass.getClass());
        }
        for (Resource classResource : classResources = contextRefreshedEvent.getApplicationContext().getResources("classpath*:" + ClassUtils.convertClassNameToResourcePath((String)packageName) + "/**/*.class")) {
            MetadataReader metadataReader = this.metadataReaderFactory.getMetadataReader(classResource);
            String className = metadataReader.getClassMetadata().getClassName();
            Class clazz = ClassUtils.forName((String)className, (ClassLoader)contextRefreshedEvent.getApplicationContext().getClassLoader());
            JoinTableInfo joinTableInfo = new JoinTableInfo();
            joinTableInfo.setTableClass(clazz);
            TableName tableNameAnnotation = clazz.getAnnotation(TableName.class);
            String tableName = "";
            if (null == tableNameAnnotation) continue;
            tableName = tableNameAnnotation.value();
            joinTableInfo.setTableName(tableName);
            ArrayList<JoinTableFieldInfo> fieldList = new ArrayList<JoinTableFieldInfo>();
            HashMap<String, FieldJoinInfo> fieldJoinInfoHashMap = new HashMap<String, FieldJoinInfo>();
            ArrayList<String> keywordList = new ArrayList<String>();
            ArrayList<String> dateTimeList = new ArrayList<String>();
            Field[] fields = clazz.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                FieldJoin fieldJoin;
                TableField tableField;
                TableLogic tableLogic;
                JoinTableFieldInfo joinTableFieldInfo = new JoinTableFieldInfo();
                Field field = fields[i];
                String fieldName = field.getName();
                Class<?> type = field.getType();
                TableId tableId = field.getAnnotation(TableId.class);
                if (null != tableId) {
                    joinTableInfo.setPrimaryKey(tableId.value());
                }
                if (null != (tableLogic = field.getAnnotation(TableLogic.class))) {
                    String value = tableLogic.value();
                    joinTableInfo.setIsDelete(true);
                    joinTableInfo.setLogicDelete(value);
                    String delval = tableLogic.delval();
                    joinTableInfo.setDeleteValue(delval.equals("") ? "1" : delval);
                }
                if ((tableField = field.getAnnotation(TableField.class)) != null) {
                    DateTime dateTime;
                    Keyword keyword;
                    String column = tableField.value();
                    joinTableFieldInfo.setField(field);
                    joinTableFieldInfo.setColumn(column);
                    joinTableFieldInfo.setProperty(fieldName);
                    joinTableFieldInfo.setPropertyType(type);
                    if (tableField.exist()) {
                        fieldList.add(joinTableFieldInfo);
                    }
                    if ((keyword = field.getAnnotation(Keyword.class)) != null) {
                        String keywordColumn = !StrUtil.isBlank((CharSequence)keyword.value()) ? keyword.value() : column;
                        keywordList.add(keywordColumn);
                    }
                    if ((dateTime = field.getAnnotation(DateTime.class)) != null) {
                        String dateTimeColumn = !StrUtil.isBlank((CharSequence)dateTime.value()) ? dateTime.value() : column;
                        dateTimeList.add(dateTimeColumn);
                    }
                }
                if (null == (fieldJoin = field.getAnnotation(FieldJoin.class))) continue;
                Join[] joins = fieldJoin.value();
                FieldJoinInfo fieldJoinInfo = new FieldJoinInfo();
                ArrayList<JoinInfo> joinInfoList = new ArrayList<JoinInfo>();
                for (int j = 0; j < joins.length; ++j) {
                    Join join = joins[j];
                    Object[] columns = join.columns();
                    JoinInfo joinInfoItem = new JoinInfo();
                    joinInfoItem.setIsResult(join.result());
                    joinInfoItem.setJoinType(join.joinType());
                    joinInfoItem.setAliasName(join.aliasName());
                    joinInfoItem.setJoinTarget(join.joinTarget());
                    joinInfoItem.setGroups(Lists.newArrayList((Object[])join.group()));
                    Object[] value = join.value();
                    joinInfoItem.setJoinConditionInfo(Lists.newArrayList((Object[])value));
                    joinInfoItem.setColumns(Lists.newArrayList((Object[])columns));
                    joinInfoList.add(joinInfoItem);
                }
                fieldJoinInfo.setJoinType(fieldJoin.joinType());
                fieldJoinInfo.setResult(fieldJoin.result().equals(Object.class) ? field.getType() : fieldJoin.result());
                fieldJoinInfo.setResultName(fieldName);
                fieldJoinInfo.setType(fieldJoin.type());
                fieldJoinInfo.setJoinInfoList(joinInfoList);
                fieldJoinInfoHashMap.put(fieldName, fieldJoinInfo);
            }
            joinTableInfo.setFieldList(fieldList);
            joinTableInfo.setJoinInfo(fieldJoinInfoHashMap);
            joinTableInfo.setKeyword(keywordList);
            JoinHelper.joinTableInfoMap.put(clazz, joinTableInfo);
        }
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.metadataReaderFactory = new SimpleMetadataReaderFactory(resourceLoader);
    }
}

