/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.cron.task;

import cn.hutool.core.exceptions.UtilException;
import cn.hutool.core.util.ClassLoaderUtil;
import cn.hutool.core.util.ClassUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.cron.CronException;
import cn.hutool.cron.task.Task;
import java.lang.reflect.Method;

public class InvokeTask
implements Task {
    private Class<?> clazz;
    private Object obj;
    private Method method;

    public InvokeTask(String classNameWithMethodName) {
        int splitIndex = classNameWithMethodName.lastIndexOf(35);
        if (splitIndex <= 0) {
            splitIndex = classNameWithMethodName.lastIndexOf(46);
        }
        if (splitIndex <= 0) {
            throw new UtilException("Invalid classNameWithMethodName [{}]!", new Object[]{classNameWithMethodName});
        }
        String className = classNameWithMethodName.substring(0, splitIndex);
        if (StrUtil.isBlank((CharSequence)className)) {
            throw new IllegalArgumentException("Class name is blank !");
        }
        this.clazz = ClassLoaderUtil.loadClass((String)className);
        if (null == this.clazz) {
            throw new IllegalArgumentException("Load class with name of [" + className + "] fail !");
        }
        this.obj = ReflectUtil.newInstanceIfPossible(this.clazz);
        String methodName = classNameWithMethodName.substring(splitIndex + 1);
        if (StrUtil.isBlank((CharSequence)methodName)) {
            throw new IllegalArgumentException("Method name is blank !");
        }
        this.method = ClassUtil.getPublicMethod(this.clazz, (String)methodName, (Class[])new Class[0]);
        if (null == this.method) {
            throw new IllegalArgumentException("No method with name of [" + methodName + "] !");
        }
    }

    @Override
    public void execute() {
        try {
            ReflectUtil.invoke((Object)this.obj, (Method)this.method, (Object[])new Object[0]);
        }
        catch (UtilException e) {
            throw new CronException(e.getCause());
        }
    }
}

