/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.cron;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.thread.ThreadUtil;
import cn.hutool.cron.CronException;
import cn.hutool.cron.CronTimer;
import cn.hutool.cron.TaskExecutorManager;
import cn.hutool.cron.TaskLauncherManager;
import cn.hutool.cron.TaskTable;
import cn.hutool.cron.listener.TaskListener;
import cn.hutool.cron.listener.TaskListenerManager;
import cn.hutool.cron.pattern.CronPattern;
import cn.hutool.cron.task.InvokeTask;
import cn.hutool.cron.task.RunnableTask;
import cn.hutool.cron.task.Task;
import cn.hutool.setting.Setting;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;

public class Scheduler {
    private Object lock = new Object();
    private TimeZone timezone;
    private boolean started = false;
    protected boolean matchSecond = false;
    protected boolean matchYear = false;
    protected boolean daemon;
    private CronTimer timer;
    protected TaskTable taskTable = new TaskTable(this);
    protected TaskLauncherManager taskLauncherManager;
    protected TaskExecutorManager taskExecutorManager;
    protected TaskListenerManager listenerManager = new TaskListenerManager();

    public Scheduler setTimeZone(TimeZone timezone) {
        this.timezone = timezone;
        return this;
    }

    public TimeZone getTimeZone() {
        return this.timezone != null ? this.timezone : TimeZone.getDefault();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Scheduler setDaemon(boolean on) throws CronException {
        Object object = this.lock;
        synchronized (object) {
            if (this.started) {
                throw new CronException("Scheduler already started!");
            }
            this.daemon = on;
        }
        return this;
    }

    public boolean isDeamon() {
        return this.daemon;
    }

    public boolean isMatchSecond() {
        return this.matchSecond;
    }

    public Scheduler setMatchSecond(boolean isMatchSecond) {
        this.matchSecond = isMatchSecond;
        return this;
    }

    public boolean isMatchYear() {
        return this.matchYear;
    }

    public Scheduler setMatchYear(boolean isMatchYear) {
        this.matchYear = isMatchYear;
        return this;
    }

    public Scheduler addListener(TaskListener listener) {
        this.listenerManager.addListener(listener);
        return this;
    }

    public Scheduler removeListener(TaskListener listener) {
        this.listenerManager.removeListener(listener);
        return this;
    }

    public Scheduler schedule(Setting cronSetting) {
        if (CollectionUtil.isNotEmpty((Map)cronSetting)) {
            for (Map.Entry entry : cronSetting.entrySet()) {
                String jobClass = Convert.toStr(entry.getKey());
                String pattern = Convert.toStr(entry.getValue());
                try {
                    this.schedule(pattern, new InvokeTask(jobClass));
                }
                catch (Exception e) {
                    throw new CronException(e, "Schedule [{}] [{}] error!", pattern, jobClass);
                }
            }
        }
        return this;
    }

    public String schedule(String pattern, Runnable task) {
        return this.schedule(pattern, new RunnableTask(task));
    }

    public String schedule(String pattern, Task task) {
        String id = UUID.randomUUID().toString();
        this.schedule(id, pattern, task);
        return id;
    }

    public Scheduler schedule(String id, String pattern, Runnable task) {
        return this.schedule(id, new CronPattern(pattern), (Task)new RunnableTask(task));
    }

    public Scheduler schedule(String id, String pattern, Task task) {
        return this.schedule(id, new CronPattern(pattern), task);
    }

    public Scheduler schedule(String id, CronPattern pattern, Task task) {
        this.taskTable.add(id, pattern, task);
        return this;
    }

    public Scheduler deschedule(String id) {
        this.taskTable.remove(id);
        return this;
    }

    public CronPattern getPattern(String id) {
        return this.taskTable.getPattern(id);
    }

    public Task getTask(String id) {
        return this.taskTable.getTask(id);
    }

    public boolean isStarted() {
        return this.started;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Scheduler start() {
        Object object = this.lock;
        synchronized (object) {
            if (this.started) {
                throw new CronException("Schedule is started!");
            }
            this.taskLauncherManager = new TaskLauncherManager(this);
            this.taskExecutorManager = new TaskExecutorManager(this);
            this.timer = new CronTimer(this);
            this.timer.setDaemon(this.daemon);
            this.timer.start();
            this.started = true;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Scheduler stop() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.started) {
                throw new IllegalStateException("Scheduler not started");
            }
            ThreadUtil.interupt((Thread)this.timer, (boolean)true);
            this.taskLauncherManager.destroy();
            this.taskExecutorManager.destroy();
            this.started = false;
        }
        return this;
    }
}

