package ${pkgName}.service.impl;

import java.util.List;
import java.io.Serializable;

import org.springframework.stereotype.Service;

import ${pkgName}.criteria.${ClassName}Criteria;
import ${pkgName}.entity.${ClassName};
import ${pkgName}.service.${ClassName}Service;
import ${baseServiceImport};
import ${pageBeanImport};

/**
 * ${ClassName} Service, generated by EasyAuto
 * BaseService中注入了通用DAO，直接调用commonDAO的数据方法方法即可
 * 
 * @author easyproject.cn
 * @version 1.0
 *
 * 
 */
@Service("${ClassName?uncap_first}Service")
public class ${ClassName}ServiceImpl extends BaseService implements ${ClassName}Service {

	@Override
	public void save(${ClassName} ${ClassName?uncap_first}) {
		commonDAO.persist(${ClassName?uncap_first});
	}

	@Override
	public void delete(Serializable id) {
		commonDAO.remove(commonDAO.find(${ClassName}.class, id));
	}
<#if Oid??>
	@Override
	public void delete(String[] values) {
		commonDAO.deleteByValues(${ClassName}.class, "${Oid}", values);
	}
	
	@Override
	public void deleteCascade(String[] values) {
		commonDAO.deleteCascadeByValues(${ClassName}.class, "${Oid}", values);
	}
</#if>
	
	@Override
	public void update(${ClassName} o) {
		commonDAO.merge(o);
	}

	@Override
	public ${ClassName} get(Serializable id) {
		return commonDAO.find(${ClassName}.class, id);
	}

	@Override
	@SuppressWarnings("rawtypes")
	public void findByPage(PageBean pageBean, ${ClassName}Criteria ${ClassName?uncap_first}Criteria) {
		pageBean.setEntityName("${ClassName} ${ClassName?uncap_first}");
		pageBean.setSelect("select ${ClassName?uncap_first}");
		
		// pagination
		commonDAO.findByPage(pageBean,${ClassName?uncap_first}Criteria);
	}

	@Override
	public int findMaxPage(int rowPerPage) {
		return (commonDAO.findMaxPage("select count(*) from ${ClassName}", rowPerPage)-1)/rowPerPage+1;
	}

	@Override
	@SuppressWarnings("unchecked")
	public List<${ClassName}> findAll(){
		return commonDAO.find("select ${ClassName?uncap_first} from ${ClassName} ${ClassName?uncap_first}");
	}




}
