package ${pkgName}.controller;

import java.io.Serializable;
import java.util.Map;

import javax.annotation.Resource;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

import ${baseControllerImport};
import ${pageBeanImport};
import ${statusCodeImport};
import ${pkgName}.criteria.${ClassName}Criteria;
import ${pkgName}.entity.${ClassName};
import ${pkgName}.service.${ClassName}Service;


 /**
 * ${ClassName} Controller, generated by EasyAuto
 *
 * 所有Controller处理类统一继承BaseController.
 * 
 * BaseController 中定义了一下内容： - request, application Servlet API -
 * 请求响应相关的JSON参数（EasyUI框架请求都是通过JSON响应） -
 * 初始化JSON响应数据的方法（setJsonMap，setJsonMsgMap，setJsonPaginationMap(PageBean,
 * Object...)） - 获得分页对象：super.getPageBean()
 * 
 * 
 * @author easyproject.cn
 * @version 1.0
 *
 */
@RestController
@RequestMapping("${ClassName}")
public class ${ClassName}Controller extends BaseController {

	public static Logger logger = LoggerFactory.getLogger(${ClassName}Controller.class);
	
	@Resource
	private ${ClassName}Service ${ClassName?uncap_first}Service;
	
	
	/**
	 * Forward to page
	 * 
	 * @return
	 */
	@RequestMapping("page")
	public ModelAndView page(ModelAndView mv) {
		mv.setViewName("main/${Module}/${ClassName}");
		return mv;
	}
	
	
	/*
	* CRUD
	*/
	

	/**
	 * List
	 * 
	 * @return
	 */
	@SuppressWarnings("rawtypes")
	@RequestMapping("list")
	public Map<Object, Object> list(${ClassName}Criteria ${ClassName?uncap_first}Criteria) {
		PageBean pb = super.getPageBean(); // 获得分页对
		${ClassName?uncap_first}Service.findByPage(pb, ${ClassName?uncap_first}Criteria);
		// EasyUI框架响应结果都是JSON
		// JSON数据初始化，包含EasySSH Ajax响应信息和分页信息
		return super.setJsonPaginationMap(pb);
	}
	
	/**
	 * Get
	 * 
	 * @return
	 */
	@RequestMapping("get")
	public Map<Object, Object> get(Serializable id) {
		${ClassName} ${ClassName?uncap_first}=null;
		try {
			${ClassName?uncap_first}=${ClassName?uncap_first}Service.get(id);
			super.setMsgKey("msg.updateSuccess");
		} catch (Exception e) {
			e.printStackTrace();
			super.setMsgKey("msg.updateFail");
			super.setStatusCode(StatusCode.ERROR); // 默认为OK
		}
		return super.setJsonMsgMap("data", ${ClassName?uncap_first});
	}

	/**
	 * Save
	 * @return
	 */
	@RequestMapping("save")
	public Map<Object, Object> save(${ClassName} ${ClassName?uncap_first}) {
		// 保存
		try {
			${ClassName?uncap_first}Service.save(${ClassName?uncap_first});
			// 处理成功 消息
			super.setMsgKey("msg.saveSuccess");
		} catch (Exception e) {
			e.printStackTrace();
			super.setMsgKey("msg.saveFail");
			super.setStatusCode(StatusCode.ERROR); // 默认为OK
		}

		/*
		 * Ajax响应信息 statusCode: 响应状态码; msg: 响应消息; callback: 执行回调函数, locationUrl:
		 * 跳转页面
		 */
		// EasyUI框架响应结果都是JSON
		// JSON数据初始化，包含EasySSH Ajax响应信息
		// super.setJsonMsgMap();

		// Add数据后，使用rowData信息更新行的内容
		// 返回JSON
		return super.setJsonMsgMap("rowData", ${ClassName?uncap_first});

		// 如果需要刷新，跳转到最后一页
		// int page = ${ClassName?uncap_first}Service.findMaxPage(rows);
		// return super.setJsonMsgMap("rowData", ${ClassName?uncap_first}, "page", page);
	}



	/**
	 * Update
	 * 
	 * @return
	 */
	@RequestMapping("update")
	public Map<Object, Object> update(${ClassName} ${ClassName?uncap_first}) {
		try {
			${ClassName?uncap_first}Service.update(${ClassName?uncap_first});
			super.setMsgKey("msg.updateSuccess");
		} catch (Exception e) {
			e.printStackTrace();
			super.setMsgKey("msg.updateFail");
			super.setStatusCode(StatusCode.ERROR); // 默认为OK
		}

		return super.setJsonMsgMap();
	}
	


<#if Oid??>	
	/**
	 * Delete
	 * 
	 * @return
	 */
	@RequestMapping("delete")
	public Map<Object, Object> delete(${ClassName} ${ClassName?uncap_first}) {
		try {
			${ClassName?uncap_first}Service.delete(${ClassName?uncap_first}.get${Oid?cap_first}());
		} catch (Exception e) {
			e.printStackTrace();
			super.setStatusCode(StatusCode.ERROR); // 默认为OK
		}
		return super.setJsonMsgMap();
	}
	
	/**
	 * DeleteBatch
	 * 
	 * @return
	 */
	@RequestMapping("deleteBatch")
	public Map<Object, Object> deleteBatch(String[] ${Oid}) {
		try {
			${ClassName?uncap_first}Service.delete(${Oid});
		} catch (Exception e) {
			e.printStackTrace();
			super.setStatusCode(StatusCode.ERROR); // 默认为OK
		}
		return super.setJsonMsgMap();
	}
	
	/**
	 * DeleteBatchCascade
	 * 
	 * @return
	 */
	@RequestMapping("deleteCascade")
	public Map<Object, Object> DeleteBatchCascade(String[] ${Oid}) {
		try {
			${ClassName?uncap_first}Service.deleteCascade(${Oid});
		} catch (Exception e) {
			e.printStackTrace();
			super.setStatusCode(StatusCode.ERROR);
		}
		return super.setJsonMsgMap();
	}
</#if>		


	
}
