/*
 * Decompiled with CFR 0.152.
 */
package cn.easyproject.easyee.auto.generator;

import cn.easyproject.easyee.auto.EasyAddDialog;
import cn.easyproject.easyee.auto.EasyAutoException;
import cn.easyproject.easyee.auto.EasyCriteria;
import cn.easyproject.easyee.auto.EasyCriterias;
import cn.easyproject.easyee.auto.EasyEditDialog;
import cn.easyproject.easyee.auto.EasyField;
import cn.easyproject.easyee.auto.EasyId;
import cn.easyproject.easyee.auto.EasyModule;
import cn.easyproject.easyee.auto.EasyPage;
import cn.easyproject.easyee.auto.PackageUtil;
import cn.easyproject.easyee.auto.PageType;
import cn.easyproject.easyee.auto.generator.EasyAutoModule;
import cn.easyproject.easyee.auto.generator.Utils;
import freemarker.core.ParseException;
import freemarker.template.Configuration;
import freemarker.template.MalformedTemplateNameException;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import freemarker.template.TemplateNotFoundException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.NameFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;

public class SMCodeGenerator {
    private final String TEMPLATE_DIR = "/templates/sm";
    private String modulePackage = null;
    private String javaModuleFolder = null;
    private String webFolder = null;
    private String resourcesFolder = null;
    private String pageBeanImport = "cn.easyproject.easyee.sm.base.pagination.PageBean";
    private String baseServiceImport = "cn.easyproject.easyee.sm.service.BaseService";
    private String easyCriteriaImport = "cn.easyproject.easyee.sm.base.pagination.EasyCriteria";
    private String stringUtilsImport = "cn.easyproject.easyee.sm.util.StringUtils";
    private String statusCodeImport = "cn.easyproject.easyee.sm.base.util.StatusCode";
    private String baseControllerImport = "cn.easyproject.easyee.sm.base.controller.BaseController";

    private void generatorFile(List<Class> allClass, String modules) throws TemplateException, IOException {
        for (Class nowClass : allClass) {
            HashMap<String, Object> root = new HashMap<String, Object>();
            String pkgName = this.modulePackage;
            String className = nowClass.getSimpleName();
            String module = this.modulePackage;
            if (module.contains(".")) {
                module = module.substring(module.lastIndexOf(".") + 1);
            }
            String oid = null;
            String oidColumn = null;
            LinkedHashSet<String> propertys = new LinkedHashSet<String>();
            LinkedHashSet<String> imports = new LinkedHashSet<String>();
            String clsLabel = className;
            LinkedHashSet<String> autos = new LinkedHashSet<String>();
            PageType pageType = PageType.NONE;
            EasyPage ee = nowClass.getAnnotation(EasyPage.class);
            if (ee != null) {
                pageType = ee.value();
            }
            Field[] fields = nowClass.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                EasyCriteria c;
                EasyField ea;
                Field f = fields[i];
                String fieldName = f.getName();
                if (fieldName.equals("serialVersionUID")) continue;
                EasyId e = f.getAnnotation(EasyId.class);
                if (e != null) {
                    oid = fieldName;
                    oidColumn = f.getAnnotation(EasyField.class).mybatisColumn();
                    if (oidColumn.equals("")) {
                        oidColumn = fieldName;
                    }
                }
                if ((ea = f.getAnnotation(EasyField.class)) != null) {
                    String label = fieldName;
                    String field = fieldName;
                    String inputField = null;
                    String mybatisColumn = null;
                    if (!ea.labelKey().equals("")) {
                        label = "<s:message code=\"" + ea.labelKey() + "\"></s:message>";
                    }
                    if (!ea.label().equals("")) {
                        label = ea.label();
                    }
                    if (!ea.field().equals("")) {
                        field = ea.field();
                    }
                    inputField = !ea.inputField().equals("") ? ea.inputField() : field;
                    mybatisColumn = ea.mybatisColumn();
                    if (mybatisColumn == null || mybatisColumn.equals("")) {
                        mybatisColumn = Utils.escapeToMyBatisName(field).toUpperCase();
                    }
                    autos.add(field + "#" + inputField + "#" + label + "#" + ea.inputRequired() + "#" + ea.show() + "#" + ea.inputShow() + "#" + ea.updateAble() + "#" + ea.inputClass() + "#" + mybatisColumn);
                }
                if ((c = f.getAnnotation(EasyCriteria.class)) == null) continue;
                String simpleTypeName = f.getType().getSimpleName();
                if (simpleTypeName.equals("byte")) {
                    simpleTypeName = "Byte";
                } else if (simpleTypeName.equals("char")) {
                    simpleTypeName = "Character";
                } else if (simpleTypeName.equals("short")) {
                    simpleTypeName = "Short";
                } else if (simpleTypeName.equals("int")) {
                    simpleTypeName = "Integer";
                } else if (simpleTypeName.equals("long")) {
                    simpleTypeName = "Long";
                } else if (simpleTypeName.equals("boolean")) {
                    simpleTypeName = "Boolean";
                } else if (simpleTypeName.equals("float")) {
                    simpleTypeName = "Float";
                } else if (simpleTypeName.equals("double")) {
                    simpleTypeName = "Double";
                } else if (!f.getType().getName().startsWith("java.lang.")) {
                    imports.add(f.getType().getName());
                }
                String type = simpleTypeName;
                String field = fieldName;
                String label = null;
                String queryConditionName = null;
                String like = "=";
                if (!c.type().getName().equals("java.lang.Object")) {
                    type = c.type().getSimpleName();
                    if (!f.getType().getName().startsWith("java.lang.")) {
                        imports.add(c.type().getName());
                    }
                }
                if (!c.filed().equals("")) {
                    field = c.filed();
                }
                queryConditionName = !c.queryConditionName().equals("") ? c.queryConditionName() : field;
                label = field;
                if (!c.labelKey().equals("")) {
                    label = "<s:message code=\"" + c.labelKey() + "\"></s:message>";
                }
                if (!c.label().equals("")) {
                    label = c.label();
                }
                if (c.like()) {
                    like = "like";
                }
                propertys.add(type + "#" + field + "#" + queryConditionName + "#" + like + "#" + label);
            }
            boolean pagination = true;
            boolean save = true;
            boolean update = true;
            boolean remove = true;
            boolean search = true;
            boolean toolbar = true;
            boolean contextMenu = true;
            boolean mutipleDelete = true;
            String table = null;
            EasyModule ea = nowClass.getAnnotation(EasyModule.class);
            if (ea != null) {
                if (!ea.labelKey().equals("")) {
                    clsLabel = "<s:message code=\"" + ea.labelKey() + "\"></s:message>";
                }
                if (!ea.label().equals("")) {
                    clsLabel = ea.label();
                }
                pagination = ea.pagination();
                save = ea.saveButton();
                update = ea.updateButton();
                remove = ea.removeButton();
                search = ea.searchButton();
                toolbar = ea.toolbar();
                contextMenu = ea.contextMenu();
                mutipleDelete = ea.mutipleDelete();
                table = ea.mybatisTable();
                if (table == null || table.equals("")) {
                    table = Utils.escapeToMyBatisName(className).toUpperCase();
                    System.out.println(table);
                }
            }
            boolean addDialog = false;
            boolean addMutilpart = false;
            EasyAddDialog ead = nowClass.getAnnotation(EasyAddDialog.class);
            if (ead != null) {
                addDialog = true;
                addMutilpart = ead.multipart();
            } else if (pageType == PageType.NONE) {
                addDialog = true;
                addMutilpart = false;
            }
            boolean editDialog = false;
            boolean editMutilpart = false;
            EasyEditDialog eed = nowClass.getAnnotation(EasyEditDialog.class);
            if (eed != null) {
                editDialog = true;
                editMutilpart = eed.multipart();
            } else if (pageType == PageType.NONE) {
                editDialog = true;
                editMutilpart = false;
            }
            EasyCriterias ca = nowClass.getAnnotation(EasyCriterias.class);
            EasyCriteria ca2 = nowClass.getAnnotation(EasyCriteria.class);
            ArrayList<EasyCriteria> clsCriterias = new ArrayList<EasyCriteria>();
            if (ca != null) {
                EasyCriteria[] cArray = ca.value();
                for (EasyCriteria criteria : cArray) {
                    clsCriterias.add(criteria);
                }
            }
            if (ca2 != null) {
                clsCriterias.add(ca2);
            }
            if (clsCriterias.size() > 0) {
                for (EasyCriteria c : clsCriterias) {
                    String type = c.type().getSimpleName();
                    String field = c.filed();
                    String queryConditionName = null;
                    String like = "=";
                    String label = null;
                    if (field.equals("")) {
                        throw new EasyAutoException("When use @Criteria on Class, you must defined 'name'");
                    }
                    if (!c.type().getName().equals("java.lang.Object")) {
                        type = c.type().getSimpleName();
                        if (!c.type().getName().startsWith("java.lang.")) {
                            imports.add(c.type().getName());
                        }
                    }
                    queryConditionName = !c.queryConditionName().equals("") ? c.queryConditionName() : field;
                    label = field;
                    if (!c.labelKey().equals("")) {
                        clsLabel = "<s:message code=\"" + c.labelKey() + "\"></s:message>";
                    }
                    if (!c.label().equals("")) {
                        label = c.label();
                    }
                    if (c.like()) {
                        like = "like";
                    }
                    propertys.add(type + "#" + field + "#" + queryConditionName + "#" + like + "#" + label);
                }
            }
            root.put("pkgName", pkgName);
            root.put("Imports", imports);
            root.put("ClassName", className);
            root.put("Propertys", propertys);
            root.put("Oid", oid);
            root.put("ClsLabel", clsLabel);
            root.put("pagination", pagination);
            root.put("save", save);
            root.put("update", update);
            root.put("remove", remove);
            root.put("search", search);
            root.put("toolbar", toolbar);
            root.put("contextMenu", contextMenu);
            root.put("mutipleDelete", mutipleDelete);
            root.put("table", table);
            root.put("oidColumn", oidColumn);
            root.put("Autos", autos);
            root.put("Module", module);
            root.put("pageBeanImport", this.pageBeanImport);
            root.put("baseServiceImport", this.baseServiceImport);
            root.put("easyCriteriaImport", this.easyCriteriaImport);
            root.put("stringUtilsImport", this.stringUtilsImport);
            root.put("statusCodeImport", this.statusCodeImport);
            root.put("baseControllerImport", this.baseControllerImport);
            root.put("addMutilpart", addMutilpart);
            root.put("editMutilpart", editMutilpart);
            Configuration cfg = new Configuration(Configuration.VERSION_2_3_23);
            cfg.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
            cfg.setDefaultEncoding("UTF-8");
            cfg.setClassForTemplateLoading(SMCodeGenerator.class, "/templates/sm");
            Template template = null;
            String fileName = null;
            String criteriaFolder = null;
            File dir = null;
            FileWriter out = null;
            if (modules.contains("criteria")) {
                template = cfg.getTemplate("criteria.tpl");
                fileName = className + "Criteria.java";
                criteriaFolder = this.javaModuleFolder + "/criteria/";
                dir = new File(criteriaFolder);
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                out = new FileWriter(criteriaFolder + fileName);
                template.process(root, (Writer)out);
                out.close();
            }
            if (modules.contains("dao")) {
                template = cfg.getTemplate("dao.tpl");
                fileName = className + "DAO.java";
                criteriaFolder = this.javaModuleFolder + "/dao/";
                dir = new File(criteriaFolder);
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                out = new FileWriter(criteriaFolder + fileName);
                template.process(root, (Writer)out);
                out.close();
            }
            if (modules.contains("mapper")) {
                template = cfg.getTemplate("mapper.tpl");
                fileName = className + "DAO.xml";
                criteriaFolder = this.resourcesFolder + "/" + module + "/";
                dir = new File(criteriaFolder);
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                out = new FileWriter(criteriaFolder + fileName);
                template.process(root, (Writer)out);
                out.close();
            }
            if (modules.contains("service")) {
                template = cfg.getTemplate("service.tpl");
                fileName = className + "Service.java";
                criteriaFolder = this.javaModuleFolder + "/service/";
                dir = new File(criteriaFolder);
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                out = new FileWriter(criteriaFolder + fileName);
                template.process(root, (Writer)out);
                out.close();
            }
            if (modules.contains("serviceImpl")) {
                template = cfg.getTemplate("serviceImpl.tpl");
                fileName = className + "ServiceImpl.java";
                criteriaFolder = this.javaModuleFolder + "/service/impl/";
                dir = new File(criteriaFolder);
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                out = new FileWriter(criteriaFolder + fileName);
                template.process(root, (Writer)out);
                out.close();
            }
            if (modules.contains("controller")) {
                template = cfg.getTemplate("controller.tpl");
                fileName = className + "Controller.java";
                criteriaFolder = this.javaModuleFolder + "/controller/";
                dir = new File(criteriaFolder);
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                out = new FileWriter(criteriaFolder + fileName);
                template.process(root, (Writer)out);
                out.close();
            }
            if (!modules.contains("page")) continue;
            if (pageType == PageType.NONE) {
                template = cfg.getTemplate("page.tpl");
                fileName = className + ".jsp";
                criteriaFolder = this.webFolder + "/main/" + module + "/";
                dir = new File(criteriaFolder);
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                out = new FileWriter(criteriaFolder + fileName);
                template.process(root, (Writer)out);
                out.close();
            } else if (pageType == PageType.ROW_EDIT) {
                template = cfg.getTemplate("page_rowedit.tpl");
                fileName = className + ".jsp";
                criteriaFolder = this.webFolder + "/main/" + module + "/";
                dir = new File(criteriaFolder);
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                out = new FileWriter(criteriaFolder + fileName);
                template.process(root, (Writer)out);
                out.close();
            } else if (pageType == PageType.CELL_EDIT) {
                template = cfg.getTemplate("page_celledit.tpl");
                fileName = className + ".jsp";
                criteriaFolder = this.webFolder + "/main/" + module + "/";
                dir = new File(criteriaFolder);
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                out = new FileWriter(criteriaFolder + fileName);
                template.process(root, (Writer)out);
                out.close();
            } else if (pageType == PageType.FORM_EDIT) {
                template = cfg.getTemplate("page_form.tpl");
                fileName = className + ".jsp";
                criteriaFolder = this.webFolder + "/main/" + module + "/";
                dir = new File(criteriaFolder);
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                out = new FileWriter(criteriaFolder + fileName);
                template.process(root, (Writer)out);
                out.close();
            }
            if (addDialog) {
                template = cfg.getTemplate("pageAdd.tpl");
                fileName = className + "Add.jsp";
                criteriaFolder = this.webFolder + "/dialog/" + module + "/";
                dir = new File(criteriaFolder);
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                out = new FileWriter(criteriaFolder + fileName);
                template.process(root, (Writer)out);
                out.close();
            }
            if (!editDialog) continue;
            template = cfg.getTemplate("pageEdit.tpl");
            fileName = className + "Edit.jsp";
            criteriaFolder = this.webFolder + "/dialog/" + module + "/";
            dir = new File(criteriaFolder);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            out = new FileWriter(criteriaFolder + fileName);
            template.process(root, (Writer)out);
            out.close();
        }
        System.out.println("\u9700\u8981\u914d\u7f6e\u7684\u6743\u9650\u5217\u8868/Need permission list");
        System.out.println("`#` Menu permissions");
        System.out.println("`-` Operation permissions");
        System.out.println();
        for (Class nowClass : allClass) {
            String className = nowClass.getSimpleName();
            System.out.println("# " + className + "/page");
            System.out.println("\t - " + className + "/list");
            System.out.println("\t - " + className + "/get");
            System.out.println("\t - " + className + "/save");
            System.out.println("\t - " + className + "/update");
            System.out.println("\t - " + className + "/delete");
            System.out.println("\t - " + className + "/deleteBatch");
        }
    }

    public void generator(String entityPackage) {
        this.generator(null, entityPackage);
    }

    public void generator(EasyAutoModule[] modules, String entityPackage) {
        try {
            List<Class> allClass = PackageUtil.getClasses(entityPackage);
            if (entityPackage.contains(".")) {
                this.modulePackage = entityPackage.substring(0, entityPackage.lastIndexOf("."));
            }
            String m = entityPackage.substring(0, entityPackage.lastIndexOf(".")).replace('.', '/');
            String basePath = System.getProperty("user.dir");
            this.javaModuleFolder = basePath + "/src/main/java/" + m;
            this.webFolder = basePath + "/src/main/webapp/WEB-INF/content";
            this.resourcesFolder = basePath + "/src/main/resources/mybatis/mapper";
            this.generatorAll(allClass, modules);
        }
        catch (TemplateNotFoundException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (MalformedTemplateNameException e) {
            e.printStackTrace();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (TemplateException e) {
            e.printStackTrace();
        }
    }

    public void generator(Class ... clses) {
        this.generator((EasyAutoModule[])null, clses);
    }

    public void generator(EasyAutoModule[] modules, Class ... clses) {
        try {
            for (Class cls : clses) {
                String entityPackage = cls.getPackage().getName();
                if (entityPackage.contains(".")) {
                    this.modulePackage = entityPackage.substring(0, entityPackage.lastIndexOf("."));
                }
                String m = entityPackage.substring(0, entityPackage.lastIndexOf(".")).replace('.', '/');
                String basePath = System.getProperty("user.dir");
                this.javaModuleFolder = basePath + "/src/main/java/" + m;
                this.webFolder = basePath + "/src/main/webapp/WEB-INF/content";
                this.resourcesFolder = basePath + "/src/main/resources/mybatis/mapper";
                ArrayList<Class> allClass = new ArrayList<Class>();
                allClass.add(cls);
                this.generatorAll(allClass, modules);
            }
        }
        catch (TemplateNotFoundException e) {
            e.printStackTrace();
        }
        catch (MalformedTemplateNameException e) {
            e.printStackTrace();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (TemplateException e) {
            e.printStackTrace();
        }
    }

    private String searchPageBeanImport(String simpleClassName) {
        String path = "";
        String basePath = System.getProperty("user.dir") + "/src/main/java/";
        Collection files = FileUtils.listFiles((File)new File(basePath), (IOFileFilter)new NameFileFilter(simpleClassName + ".java"), (IOFileFilter)TrueFileFilter.INSTANCE);
        if (files.size() > 0) {
            path = ((File)files.iterator().next()).getAbsolutePath().replace("\\", "/");
            path = path.substring(path.indexOf("src/main/java/") + "src/main/java/".length());
            path = path.replace("/", ".").substring(0, path.lastIndexOf("."));
        }
        return path;
    }

    private void generatorAll(List<Class> allClass, EasyAutoModule[] modules) throws TemplateException, IOException {
        this.pageBeanImport = this.searchPageBeanImport("PageBean");
        this.baseServiceImport = this.searchPageBeanImport("BaseService");
        this.easyCriteriaImport = this.searchPageBeanImport("EasyCriteria");
        this.stringUtilsImport = this.searchPageBeanImport("StringUtils");
        this.statusCodeImport = this.searchPageBeanImport("StatusCode");
        this.baseControllerImport = this.searchPageBeanImport("BaseController");
        String mds = "#";
        if (modules == null) {
            mds = "#controller#criteria#dao#mapper#page#service#serviceImpl#";
        } else {
            for (int i = 0; i < modules.length; ++i) {
                mds = mds + modules[i].value + "#";
            }
        }
        this.generatorFile(allClass, mds);
    }
}

