/*
 * Decompiled with CFR 0.152.
 */
package cn.com.antcloud.api.common;

import cn.com.antcloud.api.common.GwKeyValues;
import cn.com.antcloud.api.common.SDKUtils;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class BaseClientRequest {
    private final Map<String, String> parameters = new HashMap<String, String>();

    public void putParameter(String key, String value) {
        SDKUtils.checkNotNull(key);
        this.parameters.put(key, value);
    }

    public void removeParameter(String key) {
        SDKUtils.checkNotNull(key);
        this.parameters.remove(key);
    }

    public String getParameter(String key) {
        return this.parameters.get(key);
    }

    public void putParameters(Map<String, String> params) {
        SDKUtils.checkNotNull(params);
        if (params.containsKey(null)) {
            throw new IllegalArgumentException("Null key is not allowed");
        }
        this.parameters.putAll(params);
    }

    public void putParametersFromObject(Object o) {
        Map<String, String> params = GwKeyValues.toMap(o);
        this.putParameters(params);
    }

    public <T> T getParametersAsObject(Class<T> clazz) {
        return GwKeyValues.toObject(this.parameters, clazz);
    }

    public <T> T getParametersAsObject(Type type) {
        return GwKeyValues.toObject(this.parameters, type);
    }

    public Map<String, String> getParameters() {
        return Collections.unmodifiableMap(this.parameters);
    }

    public String getMethod() {
        return this.getParameter("method");
    }

    public void setMethod(String method) {
        this.putParameter("method", method);
    }

    public String getVersion() {
        return this.getParameter("version");
    }

    public void setVersion(String version) {
        this.putParameter("version", version);
    }

    public String getReqMsgId() {
        return this.getParameter("req_msg_id");
    }

    public void setReqMsgId(String reqMsgId) {
        this.putParameter("req_msg_id", reqMsgId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaseClientRequest that = (BaseClientRequest)o;
        return this.parameters != null ? this.parameters.equals(that.parameters) : that.parameters == null;
    }

    public int hashCode() {
        return this.parameters != null ? this.parameters.hashCode() : 0;
    }
}

