/*
 * Decompiled with CFR 0.152.
 */
package cn.com.antcloud.api.acapi;

import cn.com.antcloud.api.acapi.FileItem;
import cn.com.antcloud.api.acapi.StringUtils;
import cn.com.antcloud.api.rest.RestHttpMethod;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public abstract class AntCloudWebUtils {
    private static final String DEFAULT_CHARSET = "UTF-8";
    private static final String METHOD_POST = "POST";
    private static final String METHOD_GET = "GET";

    private AntCloudWebUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doRestRequest(String url, RestHttpMethod method, Map<String, String> headers, Map<String, String> queryParams, String postBody, int connectTimeout, int readTimeout, Proxy proxy) throws IOException {
        String rsp;
        String ctype = null;
        if (method.hasPostBody()) {
            ctype = "application/json;charset=UTF-8";
        }
        if (queryParams != null && !queryParams.isEmpty()) {
            url = url + "?" + AntCloudWebUtils.buildQuery(queryParams, DEFAULT_CHARSET, true);
        }
        byte[] content = new byte[]{};
        if (method.hasPostBody() && postBody != null) {
            content = postBody.getBytes(DEFAULT_CHARSET);
        }
        HttpURLConnection conn = null;
        OutputStream out = null;
        try {
            conn = AntCloudWebUtils.getConnection(new URL(url), method.getCode(), ctype, headers, proxy);
            conn.setConnectTimeout(connectTimeout);
            conn.setReadTimeout(readTimeout);
            if (method.hasPostBody()) {
                out = conn.getOutputStream();
                out.write(content);
            }
            rsp = AntCloudWebUtils.getResponseAsString(conn);
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (conn != null) {
                conn.disconnect();
            }
        }
        return rsp;
    }

    public static String doRestRequest(String url, RestHttpMethod method, Map<String, String> headers, Map<String, String> queryParams, String postBody, int connectTimeout, int readTimeout) throws IOException {
        return AntCloudWebUtils.doRestRequest(url, method, headers, queryParams, postBody, connectTimeout, readTimeout, null);
    }

    public static String doPost(String url, Map<String, String> params, int connectTimeout, int readTimeout, Proxy proxy) throws IOException {
        return AntCloudWebUtils.doPost(url, params, DEFAULT_CHARSET, connectTimeout, readTimeout, proxy);
    }

    public static String doPost(String url, Map<String, String> params, String charset, int connectTimeout, int readTimeout, Proxy proxy) throws IOException {
        return AntCloudWebUtils.doPost(url, params, charset, connectTimeout, readTimeout, null, proxy);
    }

    public static String doPost(String url, Map<String, String> params, int connectTimeout, int readTimeout) throws IOException {
        return AntCloudWebUtils.doPost(url, params, DEFAULT_CHARSET, connectTimeout, readTimeout, Proxy.NO_PROXY);
    }

    public static String doPost(String url, Map<String, String> params, String charset, int connectTimeout, int readTimeout) throws IOException {
        return AntCloudWebUtils.doPost(url, params, charset, connectTimeout, readTimeout, Proxy.NO_PROXY);
    }

    public static String doPost(String url, Map<String, String> params, String charset, int connectTimeout, int readTimeout, Map<String, String> headerMap, Proxy proxy) throws IOException {
        String ctype = "application/x-www-form-urlencoded;charset=" + charset;
        String query = AntCloudWebUtils.buildQuery(params, charset, false);
        byte[] content = new byte[]{};
        if (query != null) {
            content = query.getBytes(charset);
        }
        return AntCloudWebUtils._doPost(url, ctype, content, connectTimeout, readTimeout, headerMap, proxy);
    }

    public static String doPost(String url, Map<String, String> params, String charset, int connectTimeout, int readTimeout, Map<String, String> headerMap) throws IOException {
        return AntCloudWebUtils.doPost(url, params, charset, connectTimeout, readTimeout, headerMap, null);
    }

    @Deprecated
    public static String doPost(String url, String ctype, byte[] content, int connectTimeout, int readTimeout, Proxy proxy) throws IOException {
        return AntCloudWebUtils._doPost(url, ctype, content, connectTimeout, readTimeout, null, proxy);
    }

    @Deprecated
    public static String doPost(String url, String ctype, byte[] content, int connectTimeout, int readTimeout) throws IOException {
        return AntCloudWebUtils.doPost(url, ctype, content, connectTimeout, readTimeout, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String _doPost(String url, String ctype, byte[] content, int connectTimeout, int readTimeout, Map<String, String> headerMap, Proxy proxy) throws IOException {
        HttpURLConnection conn = null;
        OutputStream out = null;
        String rsp = null;
        try {
            conn = AntCloudWebUtils.getConnection(new URL(url), METHOD_POST, ctype, headerMap, proxy);
            conn.setConnectTimeout(connectTimeout);
            conn.setReadTimeout(readTimeout);
            out = conn.getOutputStream();
            out.write(content);
            rsp = AntCloudWebUtils.getResponseAsString(conn);
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (conn != null) {
                conn.disconnect();
            }
        }
        return rsp;
    }

    public static String doPost(String url, Map<String, String> params, Map<String, FileItem> fileParams, int connectTimeout, int readTimeout, Proxy proxy) throws IOException {
        if (fileParams == null || fileParams.isEmpty()) {
            return AntCloudWebUtils.doPost(url, params, DEFAULT_CHARSET, connectTimeout, readTimeout, proxy);
        }
        return AntCloudWebUtils.doPost(url, params, fileParams, DEFAULT_CHARSET, connectTimeout, readTimeout);
    }

    public static String doPost(String url, Map<String, String> params, Map<String, FileItem> fileParams, int connectTimeout, int readTimeout) throws IOException {
        return AntCloudWebUtils.doPost(url, params, fileParams, connectTimeout, readTimeout, null);
    }

    public static String doPost(String url, Map<String, String> params, Map<String, FileItem> fileParams, String charset, int connectTimeout, int readTimeout, Proxy proxy) throws IOException {
        return AntCloudWebUtils.doPost(url, params, fileParams, charset, connectTimeout, readTimeout, null, proxy);
    }

    public static String doPost(String url, Map<String, String> params, Map<String, FileItem> fileParams, String charset, int connectTimeout, int readTimeout) throws IOException {
        return AntCloudWebUtils.doPost(url, params, fileParams, charset, connectTimeout, readTimeout, null, null);
    }

    public static String doPost(String url, Map<String, String> params, Map<String, FileItem> fileParams, String charset, int connectTimeout, int readTimeout, Map<String, String> headerMap, Proxy proxy) throws IOException {
        if (fileParams == null || fileParams.isEmpty()) {
            return AntCloudWebUtils.doPost(url, params, charset, connectTimeout, readTimeout, headerMap, proxy);
        }
        return AntCloudWebUtils._doPostWithFile(url, params, fileParams, charset, connectTimeout, readTimeout, headerMap, proxy);
    }

    public static String doPost(String url, Map<String, String> params, Map<String, FileItem> fileParams, String charset, int connectTimeout, int readTimeout, Map<String, String> headerMap) throws IOException {
        return AntCloudWebUtils.doPost(url, params, fileParams, charset, connectTimeout, readTimeout, headerMap, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String _doPostWithFile(String url, Map<String, String> params, Map<String, FileItem> fileParams, String charset, int connectTimeout, int readTimeout, Map<String, String> headerMap, Proxy proxy) throws IOException {
        String boundary = System.currentTimeMillis() + "";
        HttpURLConnection conn = null;
        OutputStream out = null;
        String rsp = null;
        try {
            String ctype = "multipart/form-data;charset=" + charset + ";boundary=" + boundary;
            conn = AntCloudWebUtils.getConnection(new URL(url), METHOD_POST, ctype, headerMap);
            conn.setConnectTimeout(connectTimeout);
            conn.setReadTimeout(readTimeout);
            out = conn.getOutputStream();
            byte[] entryBoundaryBytes = ("\r\n--" + boundary + "\r\n").getBytes(charset);
            Set<Map.Entry<String, String>> textEntrySet = params.entrySet();
            for (Map.Entry<String, String> entry : textEntrySet) {
                byte[] byArray = AntCloudWebUtils.getTextEntry(entry.getKey(), entry.getValue(), charset);
                out.write(entryBoundaryBytes);
                out.write(byArray);
            }
            Set<Map.Entry<String, FileItem>> fileEntrySet = fileParams.entrySet();
            for (Map.Entry<String, FileItem> entry : fileEntrySet) {
                FileItem fileItem = entry.getValue();
                if (fileItem.getContent() == null) continue;
                byte[] fileBytes = AntCloudWebUtils.getFileEntry(entry.getKey(), fileItem.getFileName(), fileItem.getMimeType(), charset);
                out.write(entryBoundaryBytes);
                out.write(fileBytes);
                out.write(fileItem.getContent());
            }
            byte[] byArray = ("\r\n--" + boundary + "--\r\n").getBytes(charset);
            out.write(byArray);
            rsp = AntCloudWebUtils.getResponseAsString(conn);
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (conn != null) {
                conn.disconnect();
            }
        }
        return rsp;
    }

    private static byte[] getTextEntry(String fieldName, String fieldValue, String charset) throws IOException {
        String entry = "Content-Disposition:form-data;name=\"" + fieldName + "\"\r\nContent-Type:text/plain\r\n\r\n" + fieldValue;
        return entry.getBytes(charset);
    }

    private static byte[] getFileEntry(String fieldName, String fileName, String mimeType, String charset) throws IOException {
        String entry = "Content-Disposition:form-data;name=\"" + fieldName + "\";filename=\"" + fileName + "\"\r\nContent-Type:" + mimeType + "\r\n\r\n";
        return entry.getBytes(charset);
    }

    public static String doGet(String url, Map<String, String> params) throws IOException {
        return AntCloudWebUtils.doGet(url, params, DEFAULT_CHARSET, null);
    }

    public static String doGet(String url, Map<String, String> params, Proxy proxy) throws IOException {
        return AntCloudWebUtils.doGet(url, params, DEFAULT_CHARSET, proxy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doGet(String url, Map<String, String> params, String charset, Proxy proxy) throws IOException {
        HttpURLConnection conn = null;
        String rsp = null;
        try {
            String ctype = "application/x-www-form-urlencoded;charset=" + charset;
            String query = AntCloudWebUtils.buildQuery(params, charset, false);
            conn = AntCloudWebUtils.getConnection(AntCloudWebUtils.buildGetUrl(url, query), METHOD_GET, ctype, null, proxy);
            rsp = AntCloudWebUtils.getResponseAsString(conn);
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
        return rsp;
    }

    public static String doGet(String url, Map<String, String> params, String charset) throws IOException {
        return AntCloudWebUtils.doGet(url, params, charset, null);
    }

    private static HttpURLConnection getConnection(URL url, String method, String ctype, Map<String, String> headerMap) throws IOException {
        return AntCloudWebUtils.getConnection(url, method, ctype, headerMap, null);
    }

    private static HttpURLConnection getConnection(URL url, String method, String ctype, Map<String, String> headerMap, Proxy proxy) throws IOException {
        HttpURLConnection conn = null;
        if (proxy == null) {
            proxy = Proxy.NO_PROXY;
        }
        if ("https".equals(url.getProtocol())) {
            SSLContext ctx = null;
            try {
                ctx = SSLContext.getInstance("TLS");
                ctx.init(new KeyManager[0], new TrustManager[]{new DefaultTrustManager()}, new SecureRandom());
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            HttpsURLConnection connHttps = (HttpsURLConnection)url.openConnection(proxy);
            connHttps.setSSLSocketFactory(ctx.getSocketFactory());
            connHttps.setHostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            });
            conn = connHttps;
        } else {
            conn = (HttpURLConnection)url.openConnection(proxy);
        }
        conn.setRequestMethod(method);
        conn.setDoInput(true);
        conn.setDoOutput(true);
        conn.setRequestProperty("Accept", "text/xml,text/javascript,text/html");
        conn.setRequestProperty("User-Agent", "acapi-sdk-java");
        conn.setRequestProperty("Content-Type", ctype);
        if (headerMap != null) {
            for (Map.Entry<String, String> entry : headerMap.entrySet()) {
                conn.setRequestProperty(entry.getKey(), entry.getValue());
            }
        }
        return conn;
    }

    private static URL buildGetUrl(String strUrl, String query) throws IOException {
        URL url = new URL(strUrl);
        if (StringUtils.isEmpty(query)) {
            return url;
        }
        strUrl = StringUtils.isEmpty(url.getQuery()) ? (strUrl.endsWith("?") ? strUrl + query : strUrl + "?" + query) : (strUrl.endsWith("&") ? strUrl + query : strUrl + "&" + query);
        return new URL(strUrl);
    }

    public static String buildQuery(Map<String, String> params, String charset, boolean isRest) throws IOException {
        if (params == null || params.isEmpty()) {
            return null;
        }
        StringBuilder query = new StringBuilder();
        Set<Map.Entry<String, String>> entries = params.entrySet();
        for (Map.Entry<String, String> entry : entries) {
            String name = entry.getKey();
            String value = entry.getValue();
            if (name == null) {
                throw new IllegalArgumentException("Key cannot be null");
            }
            if (query.length() > 0) {
                query.append("&");
            }
            if (isRest) {
                name = URLEncoder.encode(name, charset);
            }
            query.append(name);
            if (value == null) continue;
            query.append("=");
            query.append(URLEncoder.encode(value, charset));
        }
        return query.toString();
    }

    protected static String getResponseAsString(HttpURLConnection conn) throws IOException {
        String charset = AntCloudWebUtils.getResponseCharset(conn.getContentType());
        InputStream es = conn.getErrorStream();
        if (es == null) {
            return AntCloudWebUtils.getStreamAsString(conn.getInputStream(), charset);
        }
        String msg = AntCloudWebUtils.getStreamAsString(es, charset);
        if (StringUtils.isEmpty(msg)) {
            throw new IOException(conn.getResponseCode() + ":" + conn.getResponseMessage());
        }
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getStreamAsString(InputStream stream, String charset) throws IOException {
        try {
            InputStreamReader reader = new InputStreamReader(stream, charset);
            StringBuilder response = new StringBuilder();
            char[] buff = new char[1024];
            int read = 0;
            while ((read = reader.read(buff)) > 0) {
                response.append(buff, 0, read);
            }
            String string = response.toString();
            return string;
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    private static String getResponseCharset(String ctype) {
        String charset = DEFAULT_CHARSET;
        if (!StringUtils.isEmpty(ctype)) {
            String[] params;
            for (String param : params = ctype.split(";")) {
                if (!(param = param.trim()).startsWith("charset")) continue;
                String[] pair = param.split("=", 2);
                if (pair.length != 2 || StringUtils.isEmpty(pair[1])) break;
                charset = pair[1].trim();
                break;
            }
        }
        return charset;
    }

    public static String decode(String value) {
        return AntCloudWebUtils.decode(value, DEFAULT_CHARSET);
    }

    public static String encode(String value) {
        return AntCloudWebUtils.encode(value, DEFAULT_CHARSET);
    }

    public static String decode(String value, String charset) {
        String result = null;
        if (!StringUtils.isEmpty(value)) {
            try {
                result = URLDecoder.decode(value, charset);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    public static String encode(String value, String charset) {
        String result = null;
        if (!StringUtils.isEmpty(value)) {
            try {
                result = URLEncoder.encode(value, charset);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    public static Map<String, String> splitUrlQuery(String query) {
        HashMap<String, String> result = new HashMap<String, String>();
        String[] pairs = query.split("&");
        if (pairs != null && pairs.length > 0) {
            for (String pair : pairs) {
                String[] param = pair.split("=", 2);
                if (param == null || param.length != 2) continue;
                result.put(param[0], param[1]);
            }
        }
        return result;
    }

    private static class DefaultTrustManager
    implements X509TrustManager {
        private DefaultTrustManager() {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }
    }
}

