/*
 * Decompiled with CFR 0.152.
 */
package cn.com.antcloud.api;

import cn.com.antcloud.api.DefaultValues;
import cn.com.antcloud.api.acapi.AntCloudHttpClient;
import cn.com.antcloud.api.acapi.HttpConfig;

public class AntFinTechProfile {
    private String accessKey;
    private String accessSecret;
    private String baseUrl;
    private int timeOutInMillis;
    private boolean enableAutoRetry = false;
    private int autoRetryLimit = 3;
    private HttpConfig httpConfig = new HttpConfig();
    private AntCloudHttpClient httpClient;
    private boolean checkSign = true;

    private AntFinTechProfile() {
    }

    public static synchronized AntFinTechProfile getProfile(String accessKey, String accessSecret) {
        AntFinTechProfile profile = new AntFinTechProfile();
        profile.setAccessKey(accessKey);
        profile.setAccessSecret(accessSecret);
        profile.setBaseUrl(DefaultValues.DEFAULT_BASE_URL);
        profile.setTimeOutInMillis(DefaultValues.DEFAULT_TIMEOUT);
        return profile;
    }

    public static synchronized AntFinTechProfile getProfile(String baseUrl, String accessKey, String accessSecret) {
        AntFinTechProfile profile = new AntFinTechProfile();
        profile.setAccessKey(accessKey);
        profile.setAccessSecret(accessSecret);
        profile.setBaseUrl(baseUrl);
        profile.setTimeOutInMillis(DefaultValues.DEFAULT_TIMEOUT);
        return profile;
    }

    public void setHttpConfig(HttpConfig httpConfig) {
        this.httpConfig = httpConfig;
        this.httpClient = new AntCloudHttpClient(httpConfig);
    }

    public HttpConfig getHttpConfig() {
        return this.httpConfig;
    }

    public AntCloudHttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setHttpClient(AntCloudHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public void enableAutoRetry(int limit) {
        this.enableAutoRetry = true;
        this.autoRetryLimit = limit;
    }

    public void disableAutoRetry() {
        this.enableAutoRetry = false;
    }

    public boolean isEnableAutoRetry() {
        return this.enableAutoRetry;
    }

    public int getAutoRetryLimit() {
        return this.autoRetryLimit;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public void setAccessSecret(String accessSecret) {
        this.accessSecret = accessSecret;
    }

    public void setTimeOutInMillis(int timeOutInMillis) {
        this.timeOutInMillis = timeOutInMillis;
    }

    public void setCheckSign(boolean checkSign) {
        this.checkSign = checkSign;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public String getAccessSecret() {
        return this.accessSecret;
    }

    public int getTimeOutInMillis() {
        return this.timeOutInMillis;
    }

    public boolean isCheckSign() {
        return this.checkSign;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = !baseUrl.endsWith("/") ? baseUrl + "/" : baseUrl;
    }
}

