/*
 * Decompiled with CFR 0.152.
 */
package cn.amossun.starter.mybatis.data.security.runner;

import cn.amossun.starter.mybatis.data.security.config.MybatisPlusDataSecurityConfig;
import cn.amossun.starter.mybatis.data.security.loader.OrmConfigCacheLoader;
import cn.amossun.starter.mybatis.data.security.runner.RedisCacheRunner;
import cn.amossun.starter.redis.cache.exception.RedisCacheConfigException;
import cn.amossun.starter.redis.cache.properties.RedisProperties;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrmConfigCacheRunner
implements RedisCacheRunner {
    private static final Logger log = LoggerFactory.getLogger(OrmConfigCacheRunner.class);
    public static final String ORM_CACHE_KEY = "platform-mall:orm-cache-key";
    private final LoadingCache<String, Object> loadingCache;
    private final String ormCacheKey;

    public OrmConfigCacheRunner(RedisProperties redisProperties, MybatisPlusDataSecurityConfig mybatisConfig, OrmConfigCacheLoader ormConfigCacheLoader) {
        this.loadingCache = CacheBuilder.newBuilder().maximumSize((long)mybatisConfig.getMybatisPlus().getCache().getMaximumSize().intValue()).refreshAfterWrite((long)mybatisConfig.getMybatisPlus().getCache().getDuration().intValue(), TimeUnit.SECONDS).build((CacheLoader)ormConfigCacheLoader);
        this.ormCacheKey = this.getOrmCacheKey(redisProperties);
    }

    protected String getOrmCacheKey(RedisProperties redisProperties) {
        if (ObjectUtil.isNull((Object)redisProperties) || StrUtil.isEmpty((CharSequence)redisProperties.getPrefix())) {
            return ORM_CACHE_KEY;
        }
        return redisProperties.getPrefix().trim() + ":" + ORM_CACHE_KEY;
    }

    @Override
    public void initCache() throws Exception {
        log.info("OrmConfigCacheRunner\u52a0\u8f7d\u6570\u636e\u4e2d.");
        Object object = this.loadingCache.get((Object)this.getCacheKey());
        if (object != null && object instanceof Optional) {
            Optional optionalObject = (Optional)object;
            log.info("OrmConfigCacheRunner\u52a0\u8f7d\u6570\u636e\u81f3GuavaCache: {}", optionalObject.isPresent() ? JSONUtil.toJsonStr(optionalObject.get()) : null);
        }
    }

    @Override
    public LoadingCache<String, Object> getLoadingCache() {
        return this.loadingCache;
    }

    @Override
    public String getCacheKey() throws RedisCacheConfigException {
        if (StrUtil.isEmpty((CharSequence)this.ormCacheKey)) {
            throw new RedisCacheConfigException("key\u4e3a\u7a7a\u503c.");
        }
        return this.ormCacheKey;
    }

    @Override
    public Object getCacheValue() throws RedisCacheConfigException, ExecutionException {
        String cacheKey = this.getCacheKey();
        return this.getLoadingCache().get((Object)cacheKey);
    }

    @Override
    public boolean refresh() throws RedisCacheConfigException {
        String cacheKey = this.getCacheKey();
        this.getLoadingCache().refresh((Object)cacheKey);
        return true;
    }

    public String getOrmCacheKey() {
        return this.ormCacheKey;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OrmConfigCacheRunner)) {
            return false;
        }
        OrmConfigCacheRunner other = (OrmConfigCacheRunner)o;
        if (!other.canEqual(this)) {
            return false;
        }
        LoadingCache<String, Object> this$loadingCache = this.getLoadingCache();
        LoadingCache<String, Object> other$loadingCache = other.getLoadingCache();
        if (this$loadingCache == null ? other$loadingCache != null : !this$loadingCache.equals(other$loadingCache)) {
            return false;
        }
        String this$ormCacheKey = this.getOrmCacheKey();
        String other$ormCacheKey = other.getOrmCacheKey();
        return !(this$ormCacheKey == null ? other$ormCacheKey != null : !this$ormCacheKey.equals(other$ormCacheKey));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OrmConfigCacheRunner;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        LoadingCache<String, Object> $loadingCache = this.getLoadingCache();
        result = result * 59 + ($loadingCache == null ? 43 : $loadingCache.hashCode());
        String $ormCacheKey = this.getOrmCacheKey();
        result = result * 59 + ($ormCacheKey == null ? 43 : $ormCacheKey.hashCode());
        return result;
    }

    public String toString() {
        return "OrmConfigCacheRunner(loadingCache=" + this.getLoadingCache() + ", ormCacheKey=" + this.getOrmCacheKey() + ")";
    }
}

