/*
 * Decompiled with CFR 0.152.
 */
package cn.amossun.starter.mybatis.data.security.runner;

import cn.amossun.starter.mybatis.data.security.config.MybatisPlusDataSecurityConfig;
import cn.amossun.starter.mybatis.data.security.loader.DecryptRuleCacheLoader;
import cn.amossun.starter.mybatis.data.security.properties.ResultMapConfiguration;
import cn.amossun.starter.mybatis.data.security.rule.MybatisDecryptRule;
import cn.amossun.starter.mybatis.data.security.runner.LocalCacheRunner;
import cn.amossun.starter.mybatis.data.security.runner.OrmConfigCacheRunner;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONUtil;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DecryptRuleLocalCacheRunner
implements LocalCacheRunner {
    private static final Logger log = LoggerFactory.getLogger(DecryptRuleLocalCacheRunner.class);
    private final MybatisDecryptRule mybatisDecryptRule;
    private final LoadingCache<String, Object> loadingCache;
    private final OrmConfigCacheRunner ormConfigCacheRunner;

    public DecryptRuleLocalCacheRunner(MybatisPlusDataSecurityConfig mybatisConfig, MybatisDecryptRule mybatisDecryptRule, DecryptRuleCacheLoader decryptRuleCacheLoader, OrmConfigCacheRunner ormConfigCacheRunner) {
        this.mybatisDecryptRule = mybatisDecryptRule;
        this.ormConfigCacheRunner = ormConfigCacheRunner;
        this.loadingCache = CacheBuilder.newBuilder().maximumSize((long)mybatisConfig.getMybatisPlus().getCache().getMaximumSize().intValue()).refreshAfterWrite((long)mybatisConfig.getMybatisPlus().getCache().getDuration().intValue(), TimeUnit.SECONDS).build((CacheLoader)decryptRuleCacheLoader);
    }

    @Override
    public void initCache() throws Exception {
        log.info("DecryptRuleLocalCacheRunner\u52a0\u8f7d\u6570\u636e\u4e2d.");
        Object object = this.ormConfigCacheRunner.getCacheValue();
        if (object == null || !(object instanceof Optional)) {
            return;
        }
        Optional optionalObject = (Optional)object;
        if (!optionalObject.isPresent()) {
            log.warn("\u83b7\u53d6redis\u52a0\u89e3\u5bc6\u914d\u7f6e\u4e3a\u7a7a.");
            return;
        }
        JSONArray jsonArray = JSONUtil.parseArray((String)JSONUtil.toJsonStr(optionalObject.get()));
        List ormConfigs = JSONUtil.toList((JSONArray)jsonArray, ResultMapConfiguration.class);
        if (CollectionUtil.isEmpty((Collection)ormConfigs)) {
            log.warn("\u83b7\u53d6redis\u52a0\u89e3\u5bc6\u914d\u7f6ejson\u6570\u7ec4\u4e3a\u7a7a.");
            return;
        }
        log.info("\u83b7\u53d6redis\u52a0\u89e3\u5bc6\u914d\u7f6ejson {} \u4e2a.", (Object)ormConfigs.size());
        if (this.refreshLocalCache(ormConfigs)) {
            log.info("DecryptRuleLocalCacheRunner\u52a0\u8f7d\u6570\u636e\u81f3GuavaCache: {}", optionalObject.isPresent() ? JSONUtil.toJsonStr(optionalObject.get()) : null);
        }
    }

    @Override
    public LoadingCache<String, Object> getLoadingCache() {
        return this.loadingCache;
    }

    @Override
    public boolean refreshLocalCache(List<ResultMapConfiguration> ormConfigs) throws Exception {
        if (CollectionUtil.isEmpty(ormConfigs)) {
            return false;
        }
        for (ResultMapConfiguration resultMapConfiguration : ormConfigs) {
            if (!ObjectUtil.isNotEmpty((Object)resultMapConfiguration) || !StrUtil.isNotEmpty((CharSequence)resultMapConfiguration.getObjectClassName())) continue;
            this.getLoadingCache().get((Object)resultMapConfiguration.getObjectClassName());
        }
        return true;
    }

    public MybatisDecryptRule getMybatisDecryptRule() {
        return this.mybatisDecryptRule;
    }

    public OrmConfigCacheRunner getOrmConfigCacheRunner() {
        return this.ormConfigCacheRunner;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DecryptRuleLocalCacheRunner)) {
            return false;
        }
        DecryptRuleLocalCacheRunner other = (DecryptRuleLocalCacheRunner)o;
        if (!other.canEqual(this)) {
            return false;
        }
        MybatisDecryptRule this$mybatisDecryptRule = this.getMybatisDecryptRule();
        MybatisDecryptRule other$mybatisDecryptRule = other.getMybatisDecryptRule();
        if (this$mybatisDecryptRule == null ? other$mybatisDecryptRule != null : !((Object)((Object)this$mybatisDecryptRule)).equals((Object)other$mybatisDecryptRule)) {
            return false;
        }
        LoadingCache<String, Object> this$loadingCache = this.getLoadingCache();
        LoadingCache<String, Object> other$loadingCache = other.getLoadingCache();
        if (this$loadingCache == null ? other$loadingCache != null : !this$loadingCache.equals(other$loadingCache)) {
            return false;
        }
        OrmConfigCacheRunner this$ormConfigCacheRunner = this.getOrmConfigCacheRunner();
        OrmConfigCacheRunner other$ormConfigCacheRunner = other.getOrmConfigCacheRunner();
        return !(this$ormConfigCacheRunner == null ? other$ormConfigCacheRunner != null : !((Object)this$ormConfigCacheRunner).equals(other$ormConfigCacheRunner));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DecryptRuleLocalCacheRunner;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MybatisDecryptRule $mybatisDecryptRule = this.getMybatisDecryptRule();
        result = result * 59 + ($mybatisDecryptRule == null ? 43 : ((Object)((Object)$mybatisDecryptRule)).hashCode());
        LoadingCache<String, Object> $loadingCache = this.getLoadingCache();
        result = result * 59 + ($loadingCache == null ? 43 : $loadingCache.hashCode());
        OrmConfigCacheRunner $ormConfigCacheRunner = this.getOrmConfigCacheRunner();
        result = result * 59 + ($ormConfigCacheRunner == null ? 43 : ((Object)$ormConfigCacheRunner).hashCode());
        return result;
    }

    public String toString() {
        return "DecryptRuleLocalCacheRunner(mybatisDecryptRule=" + (Object)((Object)this.getMybatisDecryptRule()) + ", loadingCache=" + this.getLoadingCache() + ", ormConfigCacheRunner=" + this.getOrmConfigCacheRunner() + ")";
    }
}

