/*
 * Decompiled with CFR 0.152.
 */
package cn.amossun.starter.mybatis.data.security.rule;

import cn.amossun.starter.common.crypto.rule.EncryptRule;
import cn.amossun.starter.common.properties.DataSecurityProperties;
import cn.amossun.starter.mybatis.data.security.config.MybatisPlusDataSecurityConfig;
import cn.amossun.starter.mybatis.data.security.enums.ConfigTypeEnum;
import cn.amossun.starter.mybatis.data.security.enums.SqlDmlTypeEnum;
import cn.amossun.starter.mybatis.data.security.properties.ResultConfiguration;
import cn.amossun.starter.mybatis.data.security.properties.ResultMapConfiguration;
import cn.amossun.starter.mybatis.data.security.runner.OrmConfigCacheRunner;
import cn.amossun.starter.redis.cache.exception.RedisCacheConfigException;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONUtil;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MybatisEncryptRule
extends EncryptRule {
    private static final Logger log = LoggerFactory.getLogger(MybatisEncryptRule.class);
    private final MybatisPlusDataSecurityConfig mybatisConfig;
    private final OrmConfigCacheRunner ormConfigCacheRunner;
    private Map<String, ResultMapConfiguration> ormConfigMap;

    public MybatisEncryptRule(MybatisPlusDataSecurityConfig mybatisConfig, OrmConfigCacheRunner ormConfigCacheRunner) throws Exception {
        super((DataSecurityProperties)mybatisConfig.getMybatisPlus());
        this.mybatisConfig = mybatisConfig;
        this.ormConfigCacheRunner = ormConfigCacheRunner;
        this.ormConfigMap = this.buildMapByTableName(this.getOrmConfigs());
    }

    public boolean updateOrmConfigMap() throws Exception {
        this.ormConfigMap = this.buildMapByTableName(this.getOrmConfigs());
        return true;
    }

    public Map<String, ResultMapConfiguration> getOrmConfigMap() throws Exception {
        this.updateOrmConfigMap();
        return this.ormConfigMap;
    }

    protected List<ResultMapConfiguration> getOrmConfigs() throws ExecutionException, RedisCacheConfigException {
        if (this.mybatisConfig.getMybatisPlus() == null) {
            return null;
        }
        if (this.mybatisConfig.getMybatisPlus().getConfigType() == ConfigTypeEnum.YML) {
            return this.mybatisConfig.getMybatisPlus().getOrmConfigs();
        }
        if (this.mybatisConfig.getMybatisPlus().getConfigType() == ConfigTypeEnum.REDIS) {
            Object object = this.ormConfigCacheRunner.getCacheValue();
            if (object != null && object instanceof Optional && ((Optional)object).isPresent()) {
                return JSONUtil.toList((JSONArray)JSONUtil.parseArray(((Optional)object).get()), ResultMapConfiguration.class);
            }
            return null;
        }
        return null;
    }

    protected Map<String, ResultMapConfiguration> buildMapByTableName(List<ResultMapConfiguration> ormConfigs) {
        if (CollectionUtil.isEmpty(ormConfigs)) {
            return MapUtil.newHashMap((int)0);
        }
        if (log.isDebugEnabled()) {
            log.debug("ormConfigs info-> {}", (Object)JSONUtil.toJsonStr(ormConfigs));
        }
        HashMap<String, ResultMapConfiguration> resultMapConfigurationMap = new HashMap<String, ResultMapConfiguration>(ormConfigs.size());
        ormConfigs.stream().forEach(source -> {
            Map<String, ResultConfiguration> propertyMap = source.getResults().stream().collect(Collectors.toMap(ResultConfiguration::getColumn, Function.identity(), (exiting, replacement) -> exiting));
            ResultMapConfiguration resultMapConfiguration = new ResultMapConfiguration();
            resultMapConfiguration.setTableName(source.getTableName());
            resultMapConfiguration.setPropertyMap(propertyMap);
            resultMapConfigurationMap.put(source.getTableName(), resultMapConfiguration);
        });
        return resultMapConfigurationMap;
    }

    public Optional<ResultConfiguration> getChildRuleConfiguration(String tableName, String columnName) throws Exception {
        if (!this.getOrmConfigMap().containsKey(tableName)) {
            return Optional.empty();
        }
        ResultMapConfiguration resultMapConfiguration = this.getOrmConfigMap().get(tableName);
        Map<String, ResultConfiguration> propertyMap = resultMapConfiguration.getPropertyMap();
        if (!propertyMap.containsKey(columnName.toLowerCase())) {
            return Optional.empty();
        }
        return Optional.of(propertyMap.get(columnName.toLowerCase()));
    }

    public boolean containsColumn(String tableName, String columnName) throws Exception {
        return this.getChildRuleConfiguration(tableName, columnName).isPresent();
    }

    public Object getEncryptedValue(ResultConfiguration configuration, Object originalValue) throws Exception {
        return this.getEncryptValue(configuration, originalValue);
    }

    public Object getEncryptedValue(String tableName, String columnName, Object originalValue, SqlDmlTypeEnum sqlDmlTypeEnum) throws Exception {
        Optional<ResultConfiguration> resultConfigurationOptional = this.getChildRuleConfiguration(tableName, columnName);
        if (!resultConfigurationOptional.isPresent()) {
            return originalValue;
        }
        ResultConfiguration configuration = resultConfigurationOptional.get();
        if (configuration.isEncrypt() || sqlDmlTypeEnum != null && sqlDmlTypeEnum == SqlDmlTypeEnum.INSERT) {
            return this.getEncryptValue(configuration, originalValue);
        }
        return originalValue;
    }

    private Object getEncryptValue(ResultConfiguration configuration, Object originalValue) throws BadPaddingException, IllegalBlockSizeException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, InvalidKeyException, NoSuchPaddingException, UnsupportedEncodingException {
        if (!(originalValue instanceof String) && !(originalValue instanceof Number)) {
            return originalValue;
        }
        if (null == originalValue) {
            return originalValue;
        }
        if (configuration != null && StrUtil.isNotEmpty((CharSequence)configuration.getEncryptDelimiter())) {
            List<String> originalValueList = Arrays.asList(String.valueOf(originalValue).split(configuration.getEncryptDelimiter()));
            ArrayList<String> encryptedValueList = new ArrayList<String>(originalValueList.size());
            for (String sourceStr : originalValueList) {
                encryptedValueList.add(this.encodeEncryptValue(sourceStr));
            }
            return StrUtil.join((CharSequence)configuration.getEncryptDelimiter(), encryptedValueList);
        }
        return this.encodeEncryptValue(String.valueOf(originalValue));
    }
}

