/*
 * Decompiled with CFR 0.152.
 */
package cn.amossun.starter.mybatis.data.security.rule;

import cn.amossun.starter.common.crypto.rule.DecryptRule;
import cn.amossun.starter.common.enums.DesensitizedType;
import cn.amossun.starter.common.properties.DataSecurityProperties;
import cn.amossun.starter.common.util.DesensitizedExecutor;
import cn.amossun.starter.mybatis.data.security.config.MybatisPlusDataSecurityConfig;
import cn.amossun.starter.mybatis.data.security.enums.ConfigTypeEnum;
import cn.amossun.starter.mybatis.data.security.properties.ResultConfiguration;
import cn.amossun.starter.mybatis.data.security.properties.ResultMapConfiguration;
import cn.amossun.starter.mybatis.data.security.runner.OrmConfigCacheRunner;
import cn.amossun.starter.redis.cache.exception.RedisCacheConfigException;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONUtil;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MybatisDecryptRule
extends DecryptRule {
    private static final Logger log = LoggerFactory.getLogger(MybatisDecryptRule.class);
    private final MybatisPlusDataSecurityConfig mybatisConfig;
    private final OrmConfigCacheRunner ormConfigCacheRunner;
    private Map<String, ResultMapConfiguration> ormConfigMap;
    private volatile Map<String, ResultMapConfiguration> decryptRuleMap;

    public MybatisDecryptRule(MybatisPlusDataSecurityConfig mybatisConfig, OrmConfigCacheRunner ormConfigCacheRunner) throws Exception {
        super((DataSecurityProperties)mybatisConfig.getMybatisPlus());
        this.mybatisConfig = mybatisConfig;
        this.ormConfigCacheRunner = ormConfigCacheRunner;
        this.ormConfigMap = this.buildMapByTableName(this.getOrmConfigs());
    }

    public boolean updateOrmConfigMap() throws Exception {
        this.ormConfigMap = this.buildMapByTableName(this.getOrmConfigs());
        return true;
    }

    public Map<String, ResultMapConfiguration> getOrmConfigMap() throws Exception {
        this.updateOrmConfigMap();
        return this.ormConfigMap;
    }

    public void refreshDecryptRuleMap() throws Exception {
        Map<String, ResultMapConfiguration> decryptRuleMap = this.getOrmConfigMap();
        if (CollectionUtil.isNotEmpty(decryptRuleMap)) {
            this.decryptRuleMap = decryptRuleMap;
        }
        if (CollectionUtil.isEmpty(decryptRuleMap)) {
            this.decryptRuleMap = MapUtil.newHashMap((int)0);
        }
    }

    public Map<String, ResultMapConfiguration> getDecryptRuleMap() {
        return this.decryptRuleMap;
    }

    protected List<ResultMapConfiguration> getOrmConfigs() throws ExecutionException, RedisCacheConfigException {
        if (this.mybatisConfig.getMybatisPlus() == null) {
            log.warn("mybatisPlus\u4e3a\u7a7a.");
            return null;
        }
        if (this.mybatisConfig.getMybatisPlus().getConfigType() == ConfigTypeEnum.YML) {
            log.info("\u914d\u7f6eredis json\u683c\u5f0f\u4e3ayml.");
            return this.mybatisConfig.getMybatisPlus().getOrmConfigs();
        }
        if (this.mybatisConfig.getMybatisPlus().getConfigType() == ConfigTypeEnum.REDIS) {
            Object object = this.ormConfigCacheRunner.getCacheValue();
            if (object != null && object instanceof Optional && ((Optional)object).isPresent()) {
                return JSONUtil.toList((JSONArray)JSONUtil.parseArray(((Optional)object).get()), ResultMapConfiguration.class);
            }
            log.warn("redis json\u683c\u5f0f\u914d\u7f6eredis\u4e3a\u7a7a.");
            return null;
        }
        log.warn("\u672a\u914d\u7f6eredis json\u683c\u5f0f.");
        return null;
    }

    protected Map<String, ResultMapConfiguration> buildMapByTableName(List<ResultMapConfiguration> ormConfigs) {
        if (CollectionUtil.isEmpty(ormConfigs)) {
            log.warn("\u83b7\u53d6redis\u52a0\u89e3\u5bc6\u914d\u7f6ejson \u4e3a\u7a7a.");
            return MapUtil.newHashMap((int)0);
        }
        HashMap<String, ResultMapConfiguration> resultMapConfigurationMap = new HashMap<String, ResultMapConfiguration>(ormConfigs.size());
        ormConfigs.stream().forEach(source -> {
            Map<String, ResultConfiguration> propertyMap = source.getResults().stream().collect(Collectors.toMap(ResultConfiguration::getProperty, Function.identity(), (exiting, replacement) -> exiting));
            ResultMapConfiguration resultMapConfiguration = new ResultMapConfiguration();
            resultMapConfiguration.setObjectClassName(source.getObjectClassName());
            resultMapConfiguration.setDecryptVersion(source.getDecryptVersion());
            resultMapConfiguration.setPropertyMap(propertyMap);
            resultMapConfigurationMap.put(source.getObjectClassName(), resultMapConfiguration);
        });
        return resultMapConfigurationMap;
    }

    protected Optional<ResultConfiguration> getChildRuleConfiguration(String objectName, String filedName) throws Exception {
        if (!this.getDecryptRuleMap().containsKey(objectName)) {
            return Optional.empty();
        }
        ResultMapConfiguration resultMapConfiguration = this.getDecryptRuleMap().get(objectName);
        Map<String, ResultConfiguration> propertyMap = resultMapConfiguration.getPropertyMap();
        if (!propertyMap.containsKey(filedName)) {
            return Optional.empty();
        }
        return Optional.of(propertyMap.get(filedName));
    }

    public Optional<ResultConfiguration> checkObjectValue(String objectName, String filedName) throws Exception {
        Optional<ResultConfiguration> resultConfigurationOptional = this.getChildRuleConfiguration(objectName, filedName);
        if (!resultConfigurationOptional.isPresent()) {
            return null;
        }
        return resultConfigurationOptional;
    }

    public Object decryptObjectValue(Optional<ResultConfiguration> resultConfigurationOptional, Object originalValue) throws Exception {
        if (!resultConfigurationOptional.isPresent()) {
            return originalValue;
        }
        ResultConfiguration configuration = resultConfigurationOptional.get();
        originalValue = this.decryptValue(configuration, originalValue);
        return originalValue;
    }

    public Object getDecryptValue(ResultConfiguration configuration, Object originalValue) throws BadPaddingException, IllegalBlockSizeException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, InvalidKeyException, NoSuchPaddingException, UnsupportedEncodingException {
        if (!(originalValue instanceof String) && !(originalValue instanceof Number)) {
            return originalValue;
        }
        if (configuration != null && StrUtil.isNotEmpty((CharSequence)configuration.getEncryptDelimiter())) {
            List<String> originalValueList = Arrays.asList(String.valueOf(originalValue).split(configuration.getEncryptDelimiter()));
            ArrayList<String> decryptValueList = new ArrayList<String>(originalValueList.size());
            for (String sourceStr : originalValueList) {
                decryptValueList.add(this.getDecryptValue(sourceStr));
            }
            return StrUtil.join((CharSequence)configuration.getEncryptDelimiter(), decryptValueList);
        }
        return this.getDecryptValue(String.valueOf(originalValue));
    }

    protected Object decryptValue(ResultConfiguration configuration, Object originalValue) throws BadPaddingException, IllegalBlockSizeException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, InvalidKeyException, UnsupportedEncodingException {
        if (configuration.isDecrypt()) {
            String decryptStr = String.valueOf(this.getDecryptValue(configuration, originalValue));
            if (configuration.getDesensitizedType() != null) {
                return DesensitizedExecutor.desensitized((DesensitizedType)configuration.getDesensitizedType(), (String)decryptStr);
            }
            return decryptStr;
        }
        if (configuration.getDesensitizedType() != null) {
            return DesensitizedExecutor.desensitized((DesensitizedType)configuration.getDesensitizedType(), (String)String.valueOf(originalValue));
        }
        return originalValue;
    }
}

