/*
 * Decompiled with CFR 0.152.
 */
package cn.amossun.starter.mybatis.data.security.rewrite;

import cn.amossun.starter.mybatis.data.security.core.CCJSQLStatementContext;
import cn.amossun.starter.mybatis.data.security.enums.SqlDmlTypeEnum;
import cn.amossun.starter.mybatis.data.security.rewrite.condition.DecryptEncryptCondition;
import cn.amossun.starter.mybatis.data.security.rewrite.condition.DmlDecryptEncryptCondition;
import cn.amossun.starter.mybatis.data.security.rule.MybatisEncryptRule;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.map.MapUtil;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncryptPreParameterRewriter {
    private static final Logger log = LoggerFactory.getLogger(EncryptPreParameterRewriter.class);
    private final MybatisEncryptRule encryptRule;

    public EncryptPreParameterRewriter(MybatisEncryptRule mybatisEncryptRule) throws Exception {
        this.encryptRule = mybatisEncryptRule;
    }

    public void rewrite(String sql, List<ParameterMapping> parameterMappings, Object parameterObject) throws Exception {
        CCJSQLStatementContext context = new CCJSQLStatementContext(sql, this.encryptRule);
        DmlDecryptEncryptCondition dmlDecryptEncryptCondition = context.findEncryptConditions();
        if (dmlDecryptEncryptCondition == null) {
            return;
        }
        List<DecryptEncryptCondition> encryptConditions = dmlDecryptEncryptCondition.getEncryptConditions();
        if (encryptConditions.isEmpty()) {
            return;
        }
        HashMap paramValue = MapUtil.newHashMap((int)parameterMappings.size());
        for (DecryptEncryptCondition encryptCondition : encryptConditions) {
            this.encryptParameters(encryptCondition, parameterMappings, parameterObject, paramValue, dmlDecryptEncryptCondition.getSqlDmlTypeEnum());
        }
    }

    protected void encryptParameters(DecryptEncryptCondition encryptCondition, List<ParameterMapping> parameterMappings, Object parameterObject, Map<String, Object> paramValue, SqlDmlTypeEnum sqlDmlTypeEnum) throws Exception {
        int index = encryptCondition.getIndex();
        if (CollectionUtil.isNotEmpty(parameterMappings) && parameterObject != null) {
            ParameterMapping parameterMapping = parameterMappings.get(index - 1);
            String property = parameterMapping.getProperty();
            MetaObject metaObject = SystemMetaObject.forObject((Object)parameterObject);
            Object originalValue = metaObject.getValue(property);
            if (!paramValue.containsKey(property)) {
                Object encryptedValue = this.encryptRule.getEncryptedValue(encryptCondition.getTableName(), encryptCondition.getColumnName(), originalValue, sqlDmlTypeEnum);
                metaObject.setValue(property, encryptedValue);
                paramValue.put(property, encryptedValue);
            }
        }
    }

    public String getEncryptedValue(String encryptValue) throws Exception {
        return String.valueOf(this.encryptRule.getEncryptedValue(null, encryptValue));
    }

    public String base64EncryptValue(String encryptValue) throws BadPaddingException, IllegalBlockSizeException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, InvalidKeyException, NoSuchPaddingException, UnsupportedEncodingException {
        return this.encryptRule.base64EncryptValue(encryptValue);
    }

    public String getEncryptedValueOrNull(String encryptValue) {
        try {
            return this.getEncryptedValue(encryptValue);
        }
        catch (Exception exception) {
            log.error("\u52a0\u5bc6\u5f02\u5e38: {}.", (Object)exception.getMessage());
            return null;
        }
    }

    public String getEncryptedValueOrDefault(String encryptValue) {
        try {
            return this.getEncryptedValue(encryptValue);
        }
        catch (Exception exception) {
            log.error("\u52a0\u5bc6\u5f02\u5e38: {}.", (Object)exception.getMessage());
            return encryptValue;
        }
    }

    public MybatisEncryptRule getEncryptRule() {
        return this.encryptRule;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EncryptPreParameterRewriter)) {
            return false;
        }
        EncryptPreParameterRewriter other = (EncryptPreParameterRewriter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        MybatisEncryptRule this$encryptRule = this.getEncryptRule();
        MybatisEncryptRule other$encryptRule = other.getEncryptRule();
        return !(this$encryptRule == null ? other$encryptRule != null : !((Object)((Object)this$encryptRule)).equals((Object)other$encryptRule));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EncryptPreParameterRewriter;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MybatisEncryptRule $encryptRule = this.getEncryptRule();
        result = result * 59 + ($encryptRule == null ? 43 : ((Object)((Object)$encryptRule)).hashCode());
        return result;
    }

    public String toString() {
        return "EncryptPreParameterRewriter(encryptRule=" + (Object)((Object)this.getEncryptRule()) + ")";
    }
}

