/*
 * Decompiled with CFR 0.152.
 */
package cn.amossun.starter.mybatis.data.security.rewrite;

import cn.amossun.starter.common.util.ClassUtil;
import cn.amossun.starter.mybatis.data.security.core.FieldConditionContext;
import cn.amossun.starter.mybatis.data.security.properties.ResultConfiguration;
import cn.amossun.starter.mybatis.data.security.properties.ResultMapConfiguration;
import cn.amossun.starter.mybatis.data.security.rule.MybatisDecryptRule;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DecryptPreParameterRewriter {
    private static final Logger log = LoggerFactory.getLogger(DecryptPreParameterRewriter.class);
    private final MybatisDecryptRule decryptRule;

    public DecryptPreParameterRewriter(MybatisDecryptRule mybatisDecryptRule) throws Exception {
        this.decryptRule = mybatisDecryptRule;
    }

    public void rewrite(Object result) throws Exception {
        if (result == null) {
            return;
        }
        Class<?> clazz = result.getClass();
        if (ClassUtil.isPrimitive(clazz)) {
            return;
        }
        if (result instanceof Map || result instanceof Set) {
            return;
        }
        if (result instanceof List) {
            List resultList = (List)result;
            if (CollectionUtil.isEmpty((Collection)resultList)) {
                return;
            }
            this.decryptRule.refreshDecryptRuleMap();
            if (!this.checkListFirstObject(resultList.get(0))) {
                log.info("\u5f53\u524d\u5bf9\u8c61{}, \u6682\u672a\u914d\u7f6e\u89e3\u5bc6\u5904\u7406\u89c4\u5219.", (Object)resultList.get(0).getClass().getName());
                return;
            }
            Object parameterObject = resultList.get(0);
            FieldConditionContext context = new FieldConditionContext(parameterObject, this.decryptRule);
            if (CollectionUtil.isEmpty(context.getDecryptFields())) {
                return;
            }
            for (int i = 0; i < resultList.size(); ++i) {
                parameterObject = resultList.get(i);
                if (parameterObject == null) continue;
                this.decryptObject(parameterObject, context.getDecryptFields());
            }
        } else {
            this.decryptRule.refreshDecryptRuleMap();
            if (!this.checkListFirstObject(result)) {
                log.info("\u5f53\u524d\u5bf9\u8c61{}, \u6682\u672a\u914d\u7f6e\u89e3\u5bc6\u5904\u7406\u89c4\u5219.", (Object)result.getClass().getName());
                return;
            }
            Object parameterObject = result;
            FieldConditionContext context = new FieldConditionContext(parameterObject, this.decryptRule);
            if (CollectionUtil.isEmpty(context.getDecryptFields())) {
                return;
            }
            this.decryptObject(parameterObject, context.getDecryptFields());
        }
    }

    protected boolean checkListFirstObject(Object parameterObject) throws Exception {
        if (ClassUtil.isPrimitive(parameterObject.getClass())) {
            return false;
        }
        if (parameterObject == null) {
            return false;
        }
        FieldConditionContext context = new FieldConditionContext(parameterObject, this.decryptRule);
        return this.checkDecrypt(parameterObject, context);
    }

    protected boolean checkDecrypt(Object parameterObject, FieldConditionContext context) throws Exception {
        String className = parameterObject.getClass().getName();
        ResultMapConfiguration objectConfiguration = this.decryptRule.getDecryptRuleMap().get(className);
        if (objectConfiguration == null || CollectionUtil.isEmpty(objectConfiguration.getPropertyMap())) {
            return this.checkChildObject(parameterObject, context);
        }
        return this.checkHistoryData(objectConfiguration, parameterObject);
    }

    private boolean checkHistoryData(ResultMapConfiguration objectConfiguration, Object parameterObject) throws IllegalAccessException {
        if (objectConfiguration.getDecryptVersion() == null) {
            return true;
        }
        List classFieldList = ClassUtil.getAllClassFields(parameterObject.getClass());
        if (CollectionUtil.isEmpty((Collection)classFieldList)) {
            return false;
        }
        Optional decryptVersionOptionalField = classFieldList.stream().filter(field -> "decryptVersion".equalsIgnoreCase(field.getName())).collect(Collectors.toList()).stream().findFirst();
        if (!decryptVersionOptionalField.isPresent()) {
            return false;
        }
        try {
            Field decryptVersionField = (Field)decryptVersionOptionalField.get();
            decryptVersionField.setAccessible(true);
            Object originalValues = decryptVersionField.get(parameterObject);
            if (originalValues == null || !(originalValues instanceof Number)) {
                return false;
            }
            return objectConfiguration.getDecryptVersion().equals(Integer.valueOf(String.valueOf(originalValues)));
        }
        catch (IllegalAccessException exception) {
            log.error("\u5f53\u524d\u5bf9\u8c61\u83b7\u53d6decryptVersion\u5c5e\u6027\u65f6\u53d1\u751f\u5f02\u5e38: {}", (Object)exception.getMessage());
            throw exception;
        }
    }

    private boolean checkChildObject(Object parameterObject, FieldConditionContext context) throws Exception {
        List<Field> decryptFields = context.getDecryptFields();
        if (CollectionUtil.isEmpty(decryptFields)) {
            return false;
        }
        for (Field field : decryptFields) {
            field.setAccessible(true);
            Object fieldValue = field.get(parameterObject);
            if (fieldValue == null || ClassUtil.isPrimitive(fieldValue.getClass())) continue;
            return true;
        }
        return false;
    }

    protected void decryptObject(Object parameterObject, List<Field> decryptFields) throws Exception {
        for (Field field : decryptFields) {
            Class<?> filedClass = field.getType();
            if (ClassUtil.isPrimitive(filedClass)) {
                Optional<ResultConfiguration> resultConfigurationOptional = this.decryptRule.checkObjectValue(parameterObject.getClass().getName(), field.getName());
                if (resultConfigurationOptional == null) continue;
                field.setAccessible(true);
                Object fieldValue = field.get(parameterObject);
                if (fieldValue == null || !(fieldValue instanceof String) && !(fieldValue instanceof Number) || StrUtil.isEmpty((CharSequence)String.valueOf(fieldValue))) continue;
                if (log.isDebugEnabled()) {
                    log.debug("handlerDecrypt, objectName: {} , filedName: {} , originalValues: {}.", new Object[]{parameterObject.getClass().getName(), field.getName(), fieldValue});
                }
                Object encryptedValue = this.decryptRule.decryptObjectValue(resultConfigurationOptional, fieldValue);
                field.set(parameterObject, encryptedValue);
                continue;
            }
            if (ClassUtil.isPrimitive(filedClass)) continue;
            field.setAccessible(true);
            Object fieldValue = field.get(parameterObject);
            if (fieldValue == null) continue;
            log.info("\u5b57\u6bb5\u6570\u636e\u7c7b\u578b\u975ejdk\u5305\u88c5\u7c7b\u578b&String\u7c7b\u578b&jdk\u57fa\u7840\u6570\u636e\u7c7b\u578b, \u8fdb\u5165\u9012\u5f52\u5339\u914d.");
            this.rewrite(fieldValue);
        }
    }

    public String getDecryptValue(String decryptValue) throws BadPaddingException, IllegalBlockSizeException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, InvalidKeyException, UnsupportedEncodingException {
        return String.valueOf(this.decryptRule.getDecryptValue(null, decryptValue));
    }

    public String getDecryptValueOrNull(String decryptValue) {
        try {
            return this.getDecryptValue(decryptValue);
        }
        catch (Exception exception) {
            log.error("\u89e3\u5bc6\u5f02\u5e38: {}.", (Object)exception.getMessage());
            return null;
        }
    }

    public String getDecryptValueOrDefault(String decryptValue) {
        try {
            return this.getDecryptValue(decryptValue);
        }
        catch (Exception exception) {
            log.error("\u89e3\u5bc6\u5f02\u5e38: {}.", (Object)exception.getMessage());
            return decryptValue;
        }
    }
}

