/*
 * Decompiled with CFR 0.152.
 */
package cn.amossun.starter.mybatis.data.security.loader;

import com.google.common.cache.CacheLoader;
import com.google.common.util.concurrent.JdkFutureAdapters;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

public class OrmConfigCacheLoader
extends CacheLoader<String, Object> {
    private static final Logger log = LoggerFactory.getLogger(OrmConfigCacheLoader.class);
    private final RedisTemplate amosRedisTemplate;
    private final ThreadPoolTaskExecutor amosThreadPoolTaskExecutor;

    public Optional<Object> load(String key) {
        log.info("Guava OrmConfigCacheLoader load\u66f4\u65b0key: {} ", (Object)key);
        return this.generateCacheValue(key);
    }

    public ListenableFuture<Object> reload(final String key, Object oldValue) throws Exception {
        Future future = this.amosThreadPoolTaskExecutor.submit((Callable)new Callable<Object>(){

            @Override
            public Optional<Object> call() throws Exception {
                log.info("Guava OrmConfigCacheLoader reload\u5b9a\u65f6\u5f02\u6b65\u66f4\u65b0key: {}", (Object)key);
                return OrmConfigCacheLoader.this.generateCacheValue(key);
            }
        });
        return JdkFutureAdapters.listenInPoolThread((Future)future);
    }

    Optional<Object> generateCacheValue(String key) {
        return Optional.ofNullable(this.amosRedisTemplate.opsForValue().get((Object)key));
    }

    public OrmConfigCacheLoader(RedisTemplate amosRedisTemplate, ThreadPoolTaskExecutor amosThreadPoolTaskExecutor) {
        this.amosRedisTemplate = amosRedisTemplate;
        this.amosThreadPoolTaskExecutor = amosThreadPoolTaskExecutor;
    }
}

