/*
 * Decompiled with CFR 0.152.
 */
package cn.amossun.starter.mybatis.data.security.loader;

import cn.amossun.starter.mybatis.data.security.cache.LocalCache;
import cn.amossun.starter.mybatis.data.security.core.FieldConditionContext;
import cn.amossun.starter.mybatis.data.security.properties.ResultMapConfiguration;
import cn.amossun.starter.mybatis.data.security.rule.MybatisDecryptRule;
import cn.amossun.starter.mybatis.data.security.runner.OrmConfigCacheRunner;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ClassUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONUtil;
import com.google.common.cache.CacheLoader;
import com.google.common.util.concurrent.JdkFutureAdapters;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

public class DecryptRuleCacheLoader
extends CacheLoader<String, Object> {
    private static final Logger log = LoggerFactory.getLogger(DecryptRuleCacheLoader.class);
    private final ThreadPoolTaskExecutor amosThreadPoolTaskExecutor;
    private final OrmConfigCacheRunner ormConfigCacheRunner;
    private final MybatisDecryptRule mybatisDecryptRule;

    public Optional<Object> load(String objectClassName) throws Exception {
        log.info("Guava DecryptRuleCacheLoader load\u66f4\u65b0key: {} ", (Object)objectClassName);
        return this.generateCacheValue(objectClassName);
    }

    public ListenableFuture<Object> reload(final String objectClassName, Object oldValue) throws Exception {
        Future future = this.amosThreadPoolTaskExecutor.submit((Callable)new Callable<Object>(){

            @Override
            public Optional<Object> call() throws Exception {
                log.info("Guava DecryptRuleCacheLoader reload\u5b9a\u65f6\u5f02\u6b65\u66f4\u65b0key: {}", (Object)objectClassName);
                return DecryptRuleCacheLoader.this.generateCacheValue(objectClassName);
            }
        });
        return JdkFutureAdapters.listenInPoolThread((Future)future);
    }

    Optional<Object> generateCacheValue(String objectClassName) throws Exception {
        Object object = this.ormConfigCacheRunner.getCacheValue();
        if (object == null || !(object instanceof Optional)) {
            return Optional.empty();
        }
        Optional optional = (Optional)object;
        if (!optional.isPresent()) {
            return Optional.empty();
        }
        List resultMapConfigurationList = JSONUtil.toList((JSONArray)JSONUtil.parseArray(optional.get()), ResultMapConfiguration.class);
        if (CollectionUtil.isEmpty((Collection)resultMapConfigurationList)) {
            return Optional.empty();
        }
        for (ResultMapConfiguration resultMapConfiguration : resultMapConfigurationList) {
            if (!ObjectUtil.isNotEmpty((Object)resultMapConfiguration) || !StrUtil.isNotEmpty((CharSequence)resultMapConfiguration.getObjectClassName()) || !resultMapConfiguration.getObjectClassName().equalsIgnoreCase(objectClassName) || !this.isPresent(objectClassName)) continue;
            Class objectClass = ClassUtil.loadClass((String)objectClassName);
            Object parameterObject = objectClass.newInstance();
            this.mybatisDecryptRule.refreshDecryptRuleMap();
            FieldConditionContext context = new FieldConditionContext(parameterObject, this.mybatisDecryptRule);
            LocalCache.updateObjectFiledCache(objectClassName, context.buildDecryptFields());
            log.info("\u66f4\u65b0\u672c\u5730\u672c\u5730\u7f13\u5b58\u5bf9\u8c61\u5b8c\u6210: {}.", (Object)objectClassName);
            break;
        }
        return Optional.ofNullable(LocalCache.getObjectFiledCache(objectClassName));
    }

    private boolean isPresent(String name) {
        try {
            Thread.currentThread().getContextClassLoader().loadClass(name);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public DecryptRuleCacheLoader(ThreadPoolTaskExecutor amosThreadPoolTaskExecutor, OrmConfigCacheRunner ormConfigCacheRunner, MybatisDecryptRule mybatisDecryptRule) {
        this.amosThreadPoolTaskExecutor = amosThreadPoolTaskExecutor;
        this.ormConfigCacheRunner = ormConfigCacheRunner;
        this.mybatisDecryptRule = mybatisDecryptRule;
    }
}

