/*
 * Decompiled with CFR 0.152.
 */
package cn.amossun.starter.mybatis.data.security.interceptor;

import cn.amossun.starter.mybatis.data.security.rewrite.EncryptPreParameterRewriter;
import com.baomidou.mybatisplus.core.toolkit.PluginUtils;
import java.sql.Statement;
import java.util.List;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Intercepts(value={@Signature(type=StatementHandler.class, method="parameterize", args={Statement.class})})
public class StatementHandlerInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(StatementHandlerInterceptor.class);
    private final EncryptPreParameterRewriter encryptRewriter;

    public Object intercept(Invocation invocation) throws Throwable {
        Object target = PluginUtils.realTarget((Object)invocation.getTarget());
        MetaObject metaObject = SystemMetaObject.forObject((Object)target);
        Object parameterObject = metaObject.getValue("delegate.boundSql.parameterObject");
        String sql = (String)metaObject.getValue("delegate.boundSql.sql");
        List parameterMappings = (List)metaObject.getValue("delegate.boundSql.parameterMappings");
        this.encryptRewriter.rewrite(sql, parameterMappings, parameterObject);
        return invocation.proceed();
    }

    public StatementHandlerInterceptor(EncryptPreParameterRewriter encryptRewriter) {
        this.encryptRewriter = encryptRewriter;
    }
}

