/*
 * Decompiled with CFR 0.152.
 */
package cn.amossun.starter.mybatis.data.security.interceptor;

import cn.amossun.starter.mybatis.data.security.rewrite.DecryptPreParameterRewriter;
import com.baomidou.mybatisplus.core.toolkit.PluginUtils;
import java.sql.Statement;
import org.apache.ibatis.executor.resultset.DefaultResultSetHandler;
import org.apache.ibatis.executor.resultset.ResultSetHandler;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Signature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Intercepts(value={@Signature(type=ResultSetHandler.class, method="handleResultSets", args={Statement.class})})
public class ResultSetHandlerInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(ResultSetHandlerInterceptor.class);
    private final DecryptPreParameterRewriter decryptRewriter;

    public Object intercept(Invocation invocation) throws Throwable {
        Object target = PluginUtils.realTarget((Object)invocation.getTarget());
        if (!(target instanceof DefaultResultSetHandler)) {
            return invocation.proceed();
        }
        Object result = invocation.proceed();
        this.decryptRewriter.rewrite(result);
        return result;
    }

    public ResultSetHandlerInterceptor(DecryptPreParameterRewriter decryptRewriter) {
        this.decryptRewriter = decryptRewriter;
    }
}

