/*
 * Decompiled with CFR 0.152.
 */
package cn.amossun.starter.mybatis.data.security.core;

import cn.amossun.starter.common.util.ClassUtil;
import cn.amossun.starter.mybatis.data.security.cache.LocalCache;
import cn.amossun.starter.mybatis.data.security.properties.ResultConfiguration;
import cn.amossun.starter.mybatis.data.security.properties.ResultMapConfiguration;
import cn.amossun.starter.mybatis.data.security.rule.MybatisDecryptRule;
import cn.hutool.core.collection.CollectionUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldConditionContext {
    private static final Logger log = LoggerFactory.getLogger(FieldConditionContext.class);
    private Object parameterObject;
    private MybatisDecryptRule mybatisDecryptRule;

    public List<Field> getDecryptFields() throws Exception {
        List<Field> mapFieldList = LocalCache.getObjectFiledCache(this.parameterObject.getClass().getName());
        if (CollectionUtil.isNotEmpty(mapFieldList)) {
            return mapFieldList;
        }
        List<Field> resultFieldList = this.buildDecryptFields();
        LocalCache.updateObjectFiledCache(this.parameterObject.getClass().getName(), resultFieldList);
        return resultFieldList;
    }

    public List<Field> buildDecryptFields() throws Exception {
        List objectFieldList = ClassUtil.getAllClassFields(this.parameterObject.getClass());
        if (CollectionUtil.isEmpty((Collection)objectFieldList)) {
            return null;
        }
        List<Field> rootFieldList = this.getDecryptFields(this.parameterObject.getClass());
        ArrayList<Field> resultFieldList = new ArrayList<Field>(CollectionUtil.isNotEmpty(rootFieldList) ? rootFieldList.size() + objectFieldList.size() : objectFieldList.size());
        if (CollectionUtil.isNotEmpty(rootFieldList)) {
            resultFieldList.addAll(rootFieldList);
        }
        for (Field childField : objectFieldList) {
            ResultMapConfiguration resultMapConfiguration;
            Class<?> clazz = childField.getType().getClass();
            if (ClassUtil.isPrimitive(clazz) || (resultMapConfiguration = this.mybatisDecryptRule.getDecryptRuleMap().get(clazz.getName())) == null || CollectionUtil.isEmpty(resultMapConfiguration.getPropertyMap())) continue;
            resultFieldList.add(childField);
        }
        return resultFieldList;
    }

    protected List<Field> getDecryptFields(Class<?> getClass) throws Exception {
        List classFieldList = ClassUtil.getAllClassFields(getClass);
        if (CollectionUtil.isEmpty((Collection)classFieldList)) {
            return null;
        }
        String className = getClass.getName();
        ResultMapConfiguration resultMapConfiguration = this.mybatisDecryptRule.getDecryptRuleMap().get(className);
        if (resultMapConfiguration == null || CollectionUtil.isEmpty(resultMapConfiguration.getPropertyMap())) {
            return null;
        }
        Map<String, ResultConfiguration> propertyMap = resultMapConfiguration.getPropertyMap();
        ArrayList<Field> resultFieldList = new ArrayList<Field>(resultMapConfiguration.getPropertyMap().size());
        for (Field field : classFieldList) {
            ResultConfiguration resultConfiguration;
            if (!propertyMap.containsKey(field.getName()) || !(resultConfiguration = propertyMap.get(field.getName())).isDecrypt()) continue;
            resultFieldList.add(field);
        }
        return resultFieldList;
    }

    public Object getParameterObject() {
        return this.parameterObject;
    }

    public MybatisDecryptRule getMybatisDecryptRule() {
        return this.mybatisDecryptRule;
    }

    public void setParameterObject(Object parameterObject) {
        this.parameterObject = parameterObject;
    }

    public void setMybatisDecryptRule(MybatisDecryptRule mybatisDecryptRule) {
        this.mybatisDecryptRule = mybatisDecryptRule;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FieldConditionContext)) {
            return false;
        }
        FieldConditionContext other = (FieldConditionContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Object this$parameterObject = this.getParameterObject();
        Object other$parameterObject = other.getParameterObject();
        if (this$parameterObject == null ? other$parameterObject != null : !this$parameterObject.equals(other$parameterObject)) {
            return false;
        }
        MybatisDecryptRule this$mybatisDecryptRule = this.getMybatisDecryptRule();
        MybatisDecryptRule other$mybatisDecryptRule = other.getMybatisDecryptRule();
        return !(this$mybatisDecryptRule == null ? other$mybatisDecryptRule != null : !((Object)((Object)this$mybatisDecryptRule)).equals((Object)other$mybatisDecryptRule));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FieldConditionContext;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Object $parameterObject = this.getParameterObject();
        result = result * 59 + ($parameterObject == null ? 43 : $parameterObject.hashCode());
        MybatisDecryptRule $mybatisDecryptRule = this.getMybatisDecryptRule();
        result = result * 59 + ($mybatisDecryptRule == null ? 43 : ((Object)((Object)$mybatisDecryptRule)).hashCode());
        return result;
    }

    public String toString() {
        return "FieldConditionContext(parameterObject=" + this.getParameterObject() + ", mybatisDecryptRule=" + (Object)((Object)this.getMybatisDecryptRule()) + ")";
    }

    public FieldConditionContext(Object parameterObject, MybatisDecryptRule mybatisDecryptRule) {
        this.parameterObject = parameterObject;
        this.mybatisDecryptRule = mybatisDecryptRule;
    }
}

