/*
 * Decompiled with CFR 0.152.
 */
package cn.amossun.starter.mybatis.data.security.core;

import cn.amossun.starter.mybatis.data.security.core.AbstractStatementContext;
import cn.amossun.starter.mybatis.data.security.core.CCJSQLCryptExpression;
import cn.amossun.starter.mybatis.data.security.core.CCJSQLTable;
import cn.amossun.starter.mybatis.data.security.enums.SqlDmlTypeEnum;
import cn.amossun.starter.mybatis.data.security.rewrite.condition.DecryptEncryptCondition;
import cn.amossun.starter.mybatis.data.security.rewrite.condition.DmlDecryptEncryptCondition;
import cn.amossun.starter.mybatis.data.security.rule.MybatisEncryptRule;
import cn.amossun.starter.mybatis.data.security.visitor.TablesNamesFinderPlus;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.expression.Function;
import net.sf.jsqlparser.expression.JdbcParameter;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.delete.Delete;
import net.sf.jsqlparser.statement.insert.Insert;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.SetOperationList;
import net.sf.jsqlparser.statement.update.Update;
import net.sf.jsqlparser.util.deparser.ExpressionDeParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CCJSQLStatementContext
extends AbstractStatementContext {
    private static final Logger log = LoggerFactory.getLogger(CCJSQLStatementContext.class);
    private final MybatisEncryptRule encryptRule;

    public CCJSQLStatementContext(String sql, MybatisEncryptRule encryptRule) throws JSQLParserException {
        this.setSql(sql);
        Statement statement = CCJSqlParserUtil.parse((String)sql);
        this.setStatement(statement);
        TablesNamesFinderPlus tablesNamesFinderPlus = new TablesNamesFinderPlus();
        this.setTableList(tablesNamesFinderPlus.getTableList(statement));
        this.encryptRule = encryptRule;
    }

    public DmlDecryptEncryptCondition findEncryptConditions() throws Exception {
        Statement statements = this.getStatement();
        if (statements instanceof Insert) {
            Insert insert = (Insert)statements;
            return DmlDecryptEncryptCondition.builder().encryptConditions(this.encryptResult(this.parseColumn(insert.getColumns()))).sqlDmlTypeEnum(SqlDmlTypeEnum.INSERT).build();
        }
        if (statements instanceof Delete) {
            Delete delete = (Delete)statements;
            return DmlDecryptEncryptCondition.builder().encryptConditions(this.encryptResult(this.parseDelete(delete))).sqlDmlTypeEnum(SqlDmlTypeEnum.DELETE).build();
        }
        if (statements instanceof Update) {
            Update update = (Update)statements;
            return DmlDecryptEncryptCondition.builder().encryptConditions(this.encryptResult(this.parseUpdate(update))).sqlDmlTypeEnum(SqlDmlTypeEnum.UPDATE).build();
        }
        if (statements instanceof Select) {
            Select select = (Select)statements;
            return DmlDecryptEncryptCondition.builder().encryptConditions(this.encryptResult(this.parseSelect(select))).sqlDmlTypeEnum(SqlDmlTypeEnum.SELECT).build();
        }
        return null;
    }

    protected List<DecryptEncryptCondition> encryptResult(List<CCJSQLCryptExpression> ccjSqlCryptExpressionList) throws Exception {
        if (CollectionUtil.isEmpty(ccjSqlCryptExpressionList)) {
            return Collections.emptyList();
        }
        ArrayList<DecryptEncryptCondition> result = new ArrayList<DecryptEncryptCondition>();
        for (CCJSQLCryptExpression ccjSqlCryptExpression : ccjSqlCryptExpressionList) {
            result.addAll(this.buildEncryptConditions(ccjSqlCryptExpression));
        }
        return result;
    }

    private List<CCJSQLCryptExpression> parseDelete(Delete delete) {
        return this.whereExpression(delete.getWhere());
    }

    private List<CCJSQLCryptExpression> parseUpdate(Update update) {
        List<CCJSQLCryptExpression> columnList = this.parseColumn(update.getColumns());
        List<CCJSQLCryptExpression> whereList = this.whereExpression(update.getWhere());
        ArrayList<CCJSQLCryptExpression> result = new ArrayList<CCJSQLCryptExpression>(columnList.size() + whereList.size());
        if (CollectionUtil.isNotEmpty(columnList)) {
            result.addAll(columnList);
        }
        if (CollectionUtil.isNotEmpty(whereList)) {
            result.addAll(whereList);
        }
        return result;
    }

    private List<CCJSQLCryptExpression> parseColumn(List<Column> columns) {
        ArrayList<CCJSQLCryptExpression> ccjSqlCryptExpressionList = new ArrayList<CCJSQLCryptExpression>(columns.size());
        for (int i = 0; i < columns.size(); ++i) {
            Column column = columns.get(i);
            CCJSQLCryptExpression ccjSqlCryptExpression = new CCJSQLCryptExpression();
            ccjSqlCryptExpression.setAlias(TablesNamesFinderPlus.getAlias(column.getTable()));
            ccjSqlCryptExpression.setColumnName(column.getColumnName());
            ccjSqlCryptExpression.setIndex(i + 1);
            ccjSqlCryptExpressionList.add(ccjSqlCryptExpression);
        }
        return ccjSqlCryptExpressionList;
    }

    public List<CCJSQLCryptExpression> parseSelect(Select select) {
        return this.parseSelectBody(select.getSelectBody());
    }

    protected List<CCJSQLCryptExpression> parseSelectBody(SelectBody selectBody) {
        SetOperationList setOperationList;
        if (selectBody instanceof PlainSelect) {
            PlainSelect plain = (PlainSelect)selectBody;
            return this.whereExpression(plain.getWhere());
        }
        if (selectBody instanceof SetOperationList && CollectionUtil.isNotEmpty((Collection)(setOperationList = (SetOperationList)selectBody).getSelects())) {
            ArrayList<CCJSQLCryptExpression> ccjSqlCryptExpressionList = new ArrayList<CCJSQLCryptExpression>(16);
            setOperationList.getSelects().forEach(childSelectBody -> ccjSqlCryptExpressionList.addAll(this.parseSelectBody((SelectBody)childSelectBody)));
            return ccjSqlCryptExpressionList;
        }
        return null;
    }

    protected List<CCJSQLCryptExpression> whereExpression(Expression where) {
        if (where == null) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        final ArrayList<CCJSQLCryptExpression> ccjSqlCryptExpressionList = new ArrayList<CCJSQLCryptExpression>(10);
        where.accept((ExpressionVisitor)new ExpressionDeParser(null, buffer){

            public void visit(EqualsTo equalsTo) {
                Expression leftExpression = equalsTo.getLeftExpression();
                Expression rightExpression = equalsTo.getRightExpression();
                if (leftExpression instanceof Column && rightExpression instanceof JdbcParameter) {
                    Column column = (Column)equalsTo.getLeftExpression();
                    JdbcParameter jdbcParameter = (JdbcParameter)rightExpression;
                    CCJSQLCryptExpression param = new CCJSQLCryptExpression();
                    param.setIndex(jdbcParameter.getIndex());
                    param.setAlias(TablesNamesFinderPlus.getAlias(column.getTable()));
                    param.setColumnName(column.getColumnName());
                    ccjSqlCryptExpressionList.add(param);
                }
                if (leftExpression instanceof Function && rightExpression instanceof JdbcParameter) {
                    Function function = (Function)equalsTo.getLeftExpression();
                    JdbcParameter jdbcParameter = (JdbcParameter)rightExpression;
                }
            }
        });
        return ccjSqlCryptExpressionList;
    }

    private Collection<DecryptEncryptCondition> buildEncryptConditions(CCJSQLCryptExpression ccjSqlCryptExpression) throws Exception {
        ArrayList<DecryptEncryptCondition> result = new ArrayList<DecryptEncryptCondition>();
        this.buildEncryptCondition(ccjSqlCryptExpression).ifPresent(result::add);
        return result;
    }

    private Optional<DecryptEncryptCondition> buildEncryptCondition(CCJSQLCryptExpression ccjSqlCryptExpression) throws Exception {
        Optional<String> tableName = this.findTableName(ccjSqlCryptExpression);
        DecryptEncryptCondition condition = new DecryptEncryptCondition(tableName.isPresent() ? tableName.get() : null, ccjSqlCryptExpression.getColumnName(), ccjSqlCryptExpression.getIndex());
        return tableName.isPresent() && this.containsColumn(tableName.get(), ccjSqlCryptExpression.getColumnName()) ? Optional.of(condition) : Optional.empty();
    }

    public Optional<String> findTableName(CCJSQLCryptExpression ccjSqlCryptExpression) throws Exception {
        if (this.getTableList().size() == 1) {
            return Optional.of(((CCJSQLTable)CollectionUtil.getFirst(this.getTableList())).getTableName());
        }
        if (StrUtil.isNotEmpty((CharSequence)ccjSqlCryptExpression.getAlias())) {
            return Optional.of(this.findTableNameFromSQL(ccjSqlCryptExpression.getAlias()));
        }
        return this.findTableNameFromMetaData(ccjSqlCryptExpression.getColumnName());
    }

    private Optional<String> findTableNameFromMetaData(String columnName) throws Exception {
        for (CCJSQLTable each : this.getTableList()) {
            if (!this.containsColumn(each.getTableName(), columnName)) continue;
            return Optional.of(each.getTableName());
        }
        return Optional.empty();
    }

    private boolean containsColumn(String tableName, String columnName) throws Exception {
        return this.encryptRule.containsColumn(tableName, columnName);
    }

    private String findTableNameFromSQL(String tableNameOrAlias) {
        for (CCJSQLTable ccjsqlTable : this.getTableList()) {
            if (!tableNameOrAlias.equalsIgnoreCase(ccjsqlTable.getTableName()) && !tableNameOrAlias.equals(ccjsqlTable.getAlisaName())) continue;
            return ccjsqlTable.getTableName();
        }
        throw new IllegalStateException("Can not find owner from table.");
    }

    public MybatisEncryptRule getEncryptRule() {
        return this.encryptRule;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CCJSQLStatementContext)) {
            return false;
        }
        CCJSQLStatementContext other = (CCJSQLStatementContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        MybatisEncryptRule this$encryptRule = this.getEncryptRule();
        MybatisEncryptRule other$encryptRule = other.getEncryptRule();
        return !(this$encryptRule == null ? other$encryptRule != null : !((Object)((Object)this$encryptRule)).equals((Object)other$encryptRule));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof CCJSQLStatementContext;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MybatisEncryptRule $encryptRule = this.getEncryptRule();
        result = result * 59 + ($encryptRule == null ? 43 : ((Object)((Object)$encryptRule)).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "CCJSQLStatementContext(encryptRule=" + (Object)((Object)this.getEncryptRule()) + ")";
    }
}

