/*
 * Decompiled with CFR 0.152.
 */
package cn.amossun.starter.mybatis.data.security.config;

import cn.amossun.starter.mybatis.data.security.config.MybatisPlusDataSecurityConfig;
import cn.amossun.starter.mybatis.data.security.interceptor.ExecutorInterceptor;
import cn.amossun.starter.mybatis.data.security.interceptor.ParameterHandlerInterceptor;
import cn.amossun.starter.mybatis.data.security.interceptor.ResultSetHandlerInterceptor;
import cn.amossun.starter.mybatis.data.security.interceptor.StatementHandlerInterceptor;
import cn.amossun.starter.mybatis.data.security.loader.DecryptRuleCacheLoader;
import cn.amossun.starter.mybatis.data.security.loader.OrmConfigCacheLoader;
import cn.amossun.starter.mybatis.data.security.rewrite.DecryptPreParameterRewriter;
import cn.amossun.starter.mybatis.data.security.rewrite.EncryptPreParameterRewriter;
import cn.amossun.starter.mybatis.data.security.rule.MybatisDecryptRule;
import cn.amossun.starter.mybatis.data.security.rule.MybatisEncryptRule;
import cn.amossun.starter.mybatis.data.security.runner.DecryptRuleLocalCacheRunner;
import cn.amossun.starter.mybatis.data.security.runner.OrmConfigCacheRunner;
import cn.amossun.starter.redis.cache.properties.RedisProperties;
import java.security.Provider;
import java.security.Security;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@ConditionalOnProperty(prefix="amossun.data-security", name={"mybatisPlus.enabled"}, havingValue="true")
@EnableConfigurationProperties(value={MybatisPlusDataSecurityConfig.class})
@Configuration
public class MybatisDataSecurityConfigure {
    @Bean(name={"amosThreadPoolTaskExecutor"})
    public ThreadPoolTaskExecutor amosThreadPoolTaskExecutor() {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setCorePoolSize(2);
        executor.setMaxPoolSize(4);
        executor.setQueueCapacity(100);
        executor.setThreadNamePrefix("amos-starter-async-");
        executor.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy());
        executor.initialize();
        return executor;
    }

    @Bean
    @ConditionalOnMissingBean(value={DecryptRuleCacheLoader.class})
    public DecryptRuleCacheLoader decryptRuleCacheLoader(@Autowired @Qualifier(value="amosThreadPoolTaskExecutor") ThreadPoolTaskExecutor amosThreadPoolTaskExecutor, OrmConfigCacheRunner ormConfigCacheRunner, MybatisDecryptRule mybatisDecryptRule) {
        return new DecryptRuleCacheLoader(amosThreadPoolTaskExecutor, ormConfigCacheRunner, mybatisDecryptRule);
    }

    @Bean
    @ConditionalOnMissingBean(value={DecryptRuleLocalCacheRunner.class})
    public DecryptRuleLocalCacheRunner decryptRuleLocalCacheRunner(MybatisPlusDataSecurityConfig mybatisConfig, MybatisDecryptRule mybatisDecryptRule, DecryptRuleCacheLoader decryptRuleCacheLoader, OrmConfigCacheRunner ormConfigCacheRunner) {
        return new DecryptRuleLocalCacheRunner(mybatisConfig, mybatisDecryptRule, decryptRuleCacheLoader, ormConfigCacheRunner);
    }

    @Bean
    @ConditionalOnMissingBean(value={OrmConfigCacheLoader.class})
    public OrmConfigCacheLoader ormConfigCacheLoader(@Autowired(required=false) @Qualifier(value="amosRedisTemplate") RedisTemplate amosRedisTemplate, @Autowired @Qualifier(value="amosThreadPoolTaskExecutor") ThreadPoolTaskExecutor amosThreadPoolTaskExecutor) {
        return new OrmConfigCacheLoader(amosRedisTemplate, amosThreadPoolTaskExecutor);
    }

    @Bean
    @ConditionalOnMissingBean(value={OrmConfigCacheRunner.class})
    public OrmConfigCacheRunner ormConfigCacheRunner(RedisProperties redisProperties, MybatisPlusDataSecurityConfig mybatisConfig, OrmConfigCacheLoader ormConfigCacheLoader) {
        return new OrmConfigCacheRunner(redisProperties, mybatisConfig, ormConfigCacheLoader);
    }

    @Bean
    @ConditionalOnMissingBean(value={BouncyCastleProvider.class})
    public BouncyCastleProvider addBouncyCastleProvider() {
        BouncyCastleProvider bouncyCastleProvider = new BouncyCastleProvider();
        Security.addProvider((Provider)bouncyCastleProvider);
        return bouncyCastleProvider;
    }

    @Bean
    @ConditionalOnClass(value={MybatisPlusDataSecurityConfig.class, OrmConfigCacheRunner.class})
    public MybatisEncryptRule mybatisEncryptRule(MybatisPlusDataSecurityConfig mybatisConfig, OrmConfigCacheRunner remoteCache) throws Exception {
        return new MybatisEncryptRule(mybatisConfig, remoteCache);
    }

    @Bean
    @ConditionalOnClass(value={MybatisPlusDataSecurityConfig.class, OrmConfigCacheRunner.class})
    public MybatisDecryptRule mybatisDecryptRule(MybatisPlusDataSecurityConfig mybatisConfig, OrmConfigCacheRunner remoteCache) throws Exception {
        return new MybatisDecryptRule(mybatisConfig, remoteCache);
    }

    @Bean
    @ConditionalOnClass(value={MybatisEncryptRule.class})
    public EncryptPreParameterRewriter encryptPreParameterRewriter(BouncyCastleProvider bouncyCastleProvider, MybatisEncryptRule mybatisEncryptRule) throws Exception {
        return new EncryptPreParameterRewriter(mybatisEncryptRule);
    }

    @Bean
    @ConditionalOnClass(value={MybatisDecryptRule.class})
    public DecryptPreParameterRewriter decryptPreParameterRewriter(BouncyCastleProvider bouncyCastleProvider, MybatisDecryptRule mybatisDecryptRule) throws Exception {
        return new DecryptPreParameterRewriter(mybatisDecryptRule);
    }

    @Bean
    @ConditionalOnClass(value={EncryptPreParameterRewriter.class})
    ParameterHandlerInterceptor parameterHandlerInterceptor(EncryptPreParameterRewriter encryptRewriter) {
        return new ParameterHandlerInterceptor();
    }

    @Bean
    @ConditionalOnClass(value={EncryptPreParameterRewriter.class})
    StatementHandlerInterceptor statementHandlerInterceptor(EncryptPreParameterRewriter encryptRewriter) {
        return new StatementHandlerInterceptor(encryptRewriter);
    }

    @Bean
    @ConditionalOnClass(value={EncryptPreParameterRewriter.class, DecryptPreParameterRewriter.class})
    ExecutorInterceptor executorInterceptor(EncryptPreParameterRewriter encryptRewriter, DecryptPreParameterRewriter decryptRewriter) {
        return new ExecutorInterceptor();
    }

    @Bean
    @ConditionalOnClass(value={EncryptPreParameterRewriter.class, DecryptPreParameterRewriter.class})
    ResultSetHandlerInterceptor resultSetHandlerInterceptor(DecryptPreParameterRewriter decryptRewriter) {
        return new ResultSetHandlerInterceptor(decryptRewriter);
    }
}

