/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.sqlite;

import schemacrawler.schemacrawler.Config;
import schemacrawler.schemacrawler.ConnectionOptions;
import schemacrawler.schemacrawler.DatabaseSpecificOverrideOptionsBuilder;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.schemacrawler.UserCredentials;
import schemacrawler.tools.databaseconnector.DatabaseConnector;
import schemacrawler.tools.databaseconnector.DatabaseServerType;

public final class SQLiteDatabaseConnector
extends DatabaseConnector {
    private static final long serialVersionUID = -926915070636247650L;

    public SQLiteDatabaseConnector() {
        super(new DatabaseServerType("sqlite", "SQLite"), "/help/Connections.sqlite.txt", "/schemacrawler-sqlite.config.properties", "/sqlite.information_schema", "jdbc:sqlite:.*");
    }

    public DatabaseSpecificOverrideOptionsBuilder getDatabaseSpecificOverrideOptionsBuilder() {
        DatabaseSpecificOverrideOptionsBuilder databaseSpecificOverrideOptionsBuilder = super.getDatabaseSpecificOverrideOptionsBuilder();
        databaseSpecificOverrideOptionsBuilder.identifierQuoteString("\"");
        return databaseSpecificOverrideOptionsBuilder;
    }

    public ConnectionOptions newDatabaseConnectionOptions(UserCredentials userCredentials, Config additionalConfig) throws SchemaCrawlerException {
        try {
            Class.forName("org.sqlite.JDBC");
        }
        catch (ClassNotFoundException e) {
            throw new SchemaCrawlerException("Could not load SQLite JDBC driver", (Throwable)e);
        }
        return super.newDatabaseConnectionOptions(userCredentials, additionalConfig);
    }
}

