/*
 * Decompiled with CFR 0.152.
 */
package uk.modl.model;

import io.vavr.Tuple2;
import io.vavr.collection.Vector;
import lombok.NonNull;
import uk.modl.ancestry.Ancestry;
import uk.modl.ancestry.Child;
import uk.modl.ancestry.Parent;
import uk.modl.model.ConditionOrConditionGroupInterface;
import uk.modl.model.ConditionTest;
import uk.modl.utils.IDSource;

public final class ConditionGroup
implements ConditionOrConditionGroupInterface,
Parent,
Child {
    private final long id;
    @NonNull
    private final Vector<Tuple2<ConditionTest, String>> subConditionList;
    private final boolean shouldNegate;

    public static ConditionGroup of(Ancestry ancestry, Parent parent, Vector<Tuple2<ConditionTest, String>> subConditionList, boolean shouldNegate) {
        ConditionGroup child = ConditionGroup.of(IDSource.nextId(), subConditionList, shouldNegate);
        ancestry.add(parent, child);
        return child;
    }

    public ConditionGroup with(Ancestry ancestry, Vector<Tuple2<ConditionTest, String>> subConditionList, boolean shouldNegate) {
        ConditionGroup child = ConditionGroup.of(this.id, subConditionList, shouldNegate);
        ancestry.replaceChild(this, child);
        return child;
    }

    private ConditionGroup(long id, @NonNull Vector<Tuple2<ConditionTest, String>> subConditionList, boolean shouldNegate) {
        if (subConditionList == null) {
            throw new NullPointerException("subConditionList is marked non-null but is null");
        }
        this.id = id;
        this.subConditionList = subConditionList;
        this.shouldNegate = shouldNegate;
    }

    public static ConditionGroup of(long id, @NonNull Vector<Tuple2<ConditionTest, String>> subConditionList, boolean shouldNegate) {
        return new ConditionGroup(id, subConditionList, shouldNegate);
    }

    @Override
    public long getId() {
        return this.id;
    }

    @NonNull
    public Vector<Tuple2<ConditionTest, String>> getSubConditionList() {
        return this.subConditionList;
    }

    public boolean isShouldNegate() {
        return this.shouldNegate;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConditionGroup)) {
            return false;
        }
        ConditionGroup other = (ConditionGroup)o;
        return this.getId() == other.getId();
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $id = this.getId();
        result = result * 59 + (int)($id >>> 32 ^ $id);
        return result;
    }

    public String toString() {
        return "ConditionGroup(subConditionList=" + this.getSubConditionList() + ", shouldNegate=" + this.isShouldNegate() + ")";
    }
}

