/*
 * Decompiled with CFR 0.152.
 */
package uk.modl.utils;

import io.vavr.API;
import io.vavr.Predicates;
import io.vavr.collection.List;
import io.vavr.control.Option;
import java.util.Objects;
import uk.modl.model.Array;
import uk.modl.model.FalsePrimitive;
import uk.modl.model.Map;
import uk.modl.model.NullPrimitive;
import uk.modl.model.NumberPrimitive;
import uk.modl.model.Pair;
import uk.modl.model.PairValue;
import uk.modl.model.StringPrimitive;
import uk.modl.model.TruePrimitive;
import uk.modl.transforms.StarClassTransform;
import uk.modl.transforms.TransformationContext;

public class SupertypeInference {
    private static final int MAX_RECURSION_DEPTH = 50;

    public static String inferType(TransformationContext ctx, StarClassTransform.ClassInstruction ci, PairValue pv) {
        String tc = SupertypeInference.topClass(ctx, ci, 0);
        if (tc == null) {
            tc = SupertypeInference.hasAssignStatement(ctx, ci) ? (SupertypeInference.allAssignmentKeysAreClasses(ctx, ci) ? "arr" : "map") : (SupertypeInference.hasInheritedPairs(ctx, ci, 0) ? "map" : (String)API.Match(pv).of(API.Case(API.$(Predicates.instanceOf(StringPrimitive.class)), "str"), API.Case(API.$(Predicates.instanceOf(NumberPrimitive.class)), "num"), API.Case(API.$(Predicates.instanceOf(TruePrimitive.class)), "bool"), API.Case(API.$(Predicates.instanceOf(FalsePrimitive.class)), "bool"), API.Case(API.$(Predicates.instanceOf(NullPrimitive.class)), "null"), API.Case(API.$(Predicates.instanceOf(Array.class)), "arr"), API.Case(API.$(Predicates.instanceOf(Map.class)), "map"), API.Case(API.$(Predicates.instanceOf(Pair.class)), "map"), API.Case(API.$(), () -> {
                throw new NullPointerException("Unknown object type: " + pv.getClass());
            })));
        }
        return tc;
    }

    private static boolean hasInheritedPairs(TransformationContext ctx, StarClassTransform.ClassInstruction ci, int depth) {
        if (depth > 50 || ci == null) {
            return false;
        }
        if (ci.getPairs().length() > 0) {
            return true;
        }
        return ctx.getClassByNameOrId(ci.getSuperclass()).map(sc -> SupertypeInference.hasInheritedPairs(ctx, sc, depth + 1)).getOrElse(false);
    }

    private static boolean allAssignmentKeysAreClasses(TransformationContext ctx, StarClassTransform.ClassInstruction ci) {
        List<String> allInheritedAssignKeys = SupertypeInference.allInheritedAssignKeys(ctx, ci, 0);
        boolean allHaveAssigns = SupertypeInference.allAssignClassesHaveAssigns(ctx, allInheritedAssignKeys);
        boolean allAssignKeysAreClasses = allInheritedAssignKeys.map(ctx::getClassByNameOrId).count(Objects::isNull) == 0;
        return allHaveAssigns && allAssignKeysAreClasses;
    }

    private static boolean allAssignClassesHaveAssigns(TransformationContext ctx, List<String> allInheritedAssignKeys) {
        int expected = allInheritedAssignKeys.size();
        return expected == allInheritedAssignKeys.count(key -> {
            Option<StarClassTransform.ClassInstruction> maybeClass = ctx.getClassByNameOrId((String)key);
            return maybeClass.isDefined() && maybeClass.get().getAssign().nonEmpty();
        });
    }

    private static boolean hasAssignStatement(TransformationContext ctx, StarClassTransform.ClassInstruction ci) {
        return SupertypeInference.allInheritedAssignKeys(ctx, ci, 0).nonEmpty();
    }

    private static List<String> allInheritedAssignKeys(TransformationContext ctx, StarClassTransform.ClassInstruction ci, int depth) {
        if (depth > 50 || ci == null) {
            return List.empty();
        }
        List assignKeys = ci.getAssign().map(x -> ((Array)x).getArrayItems().map(Object::toString)).foldLeft(List.empty(), List::appendAll);
        return assignKeys.appendAll((Iterable)ctx.getClassByNameOrId(ci.getSuperclass()).map(sc -> SupertypeInference.allInheritedAssignKeys(ctx, sc, depth + 1)).getOrElse(List.empty()));
    }

    private static String topClass(TransformationContext ctx, StarClassTransform.ClassInstruction ci, int depth) {
        if (depth > 50 || ci == null) {
            return null;
        }
        return ctx.getClassByNameOrId(ci.getSuperclass()).map(sc -> SupertypeInference.topClass(ctx, sc, depth + 1)).getOrElse(ci.getSuperclass());
    }
}

