/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.core;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.dao.TypeMismatchDataAccessException;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.util.NumberUtils;

public class SingleColumnRowMapper
implements RowMapper {
    private Class requiredType;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Number;

    public SingleColumnRowMapper() {
    }

    public SingleColumnRowMapper(Class requiredType) {
        this.requiredType = requiredType;
    }

    public void setRequiredType(Class requiredType) {
        this.requiredType = requiredType;
    }

    public Object mapRow(ResultSet rs, int rowNum) throws SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        int nrOfColumns = rsmd.getColumnCount();
        if (nrOfColumns != 1) {
            throw new IncorrectResultSizeDataAccessException("Expected single column but found " + nrOfColumns, 1, nrOfColumns);
        }
        Object result = this.getColumnValue(rs, 1);
        if (result != null && this.requiredType != null && !this.requiredType.isInstance(result)) {
            if ((class$java$lang$String == null ? (class$java$lang$String = SingleColumnRowMapper.class$("java.lang.String")) : class$java$lang$String).equals(this.requiredType)) {
                result = result.toString();
            } else if ((class$java$lang$Number == null ? (class$java$lang$Number = SingleColumnRowMapper.class$("java.lang.Number")) : class$java$lang$Number).isAssignableFrom(this.requiredType) && (class$java$lang$Number == null ? (class$java$lang$Number = SingleColumnRowMapper.class$("java.lang.Number")) : class$java$lang$Number).isInstance(result)) {
                try {
                    result = NumberUtils.convertNumberToTargetClass((Number)result, this.requiredType);
                }
                catch (IllegalArgumentException ex) {
                    throw new TypeMismatchDataAccessException(ex.getMessage());
                }
            } else {
                throw new TypeMismatchDataAccessException("Result object with column type '" + rsmd.getColumnTypeName(1) + "' and value [" + result + "] is of type [" + rsmd.getColumnClassName(1) + "] and could not be converted to required type [" + this.requiredType.getName() + "]");
            }
        }
        return result;
    }

    protected Object getColumnValue(ResultSet rs, int index) throws SQLException {
        return JdbcUtils.getResultSetValue(rs, index);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

