/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.faces.webflow;

import javax.el.ELContext;
import javax.el.ExpressionFactory;
import javax.el.ValueExpression;
import javax.faces.context.FacesContext;
import org.springframework.expression.AccessException;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.TypedValue;
import org.springframework.faces.webflow.FlowFacesContext;
import org.springframework.faces.webflow.FlowLifecycle;
import org.springframework.util.Assert;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.RequestContextHolder;

public class JsfManagedBeanPropertyAccessor
implements PropertyAccessor {
    public Class[] getSpecificTargetClasses() {
        return null;
    }

    public boolean canRead(EvaluationContext context, Object target, String name) throws AccessException {
        return this.getJsfManagedBean(name) != null;
    }

    public TypedValue read(EvaluationContext context, Object target, String name) throws AccessException {
        return new TypedValue(this.getJsfManagedBean(name));
    }

    public boolean canWrite(EvaluationContext context, Object target, String name) throws AccessException {
        return this.getScopeForBean(name) != null;
    }

    public void write(EvaluationContext context, Object target, String name, Object newValue) throws AccessException {
        MutableAttributeMap map = this.getScopeForBean(name);
        if (map != null) {
            map.put(name, newValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getJsfManagedBean(String name) {
        RequestContext requestContext = RequestContextHolder.getRequestContext();
        Assert.notNull((Object)requestContext, (String)"RequestContext cannot be null. This PropertyAccessor is only intended to be invoked from an active Flow Execution.");
        boolean releaseFacesContext = false;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext == null) {
            releaseFacesContext = true;
            facesContext = FlowFacesContext.newInstance(requestContext, FlowLifecycle.newInstance());
        }
        try {
            ExpressionFactory factory = facesContext.getApplication().getExpressionFactory();
            ELContext elContext = facesContext.getELContext();
            ValueExpression expression = factory.createValueExpression(elContext, "#{" + name + "}", Object.class);
            Object object = expression.getValue(facesContext.getELContext());
            return object;
        }
        finally {
            if (releaseFacesContext) {
                facesContext.release();
            }
        }
    }

    private MutableAttributeMap getScopeForBean(String name) {
        ExternalContext externalContext = RequestContextHolder.getRequestContext().getExternalContext();
        if (externalContext.getRequestMap().contains(name)) {
            return externalContext.getRequestMap();
        }
        if (externalContext.getSessionMap().contains(name)) {
            return externalContext.getSessionMap();
        }
        if (externalContext.getApplicationMap().contains(name)) {
            return externalContext.getApplicationMap();
        }
        return null;
    }
}

