/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.simp.stomp;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.messaging.Message;
import org.springframework.messaging.simp.SimpMessageType;
import org.springframework.messaging.simp.stomp.StompCommand;
import org.springframework.messaging.simp.stomp.StompConversionException;
import org.springframework.messaging.simp.stomp.StompHeaderAccessor;

public final class StompEncoder {
    private static final byte LF = 10;
    private static final byte COLON = 58;
    private static final Charset UTF8_CHARSET = Charset.forName("UTF-8");
    private final Log logger = LogFactory.getLog(StompEncoder.class);

    public byte[] encode(Message<byte[]> message) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(256);
            DataOutputStream output = new DataOutputStream(baos);
            StompHeaderAccessor headers = StompHeaderAccessor.wrap(message);
            if (this.isHeartbeat(headers)) {
                output.write(message.getPayload());
            } else {
                this.writeCommand(headers, output);
                this.writeHeaders(headers, message, output);
                output.write(10);
                this.writeBody(message, output);
                output.write(0);
            }
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new StompConversionException("Failed to encode STOMP frame", e);
        }
    }

    private boolean isHeartbeat(StompHeaderAccessor headers) {
        return headers.getMessageType() == SimpMessageType.HEARTBEAT;
    }

    private void writeCommand(StompHeaderAccessor headers, DataOutputStream output) throws IOException {
        output.write(headers.getCommand().toString().getBytes(UTF8_CHARSET));
        output.write(10);
    }

    private void writeHeaders(StompHeaderAccessor headers, Message<byte[]> message, DataOutputStream output) throws IOException {
        Map<String, List<String>> stompHeaders = headers.toStompHeaderMap();
        if (SimpMessageType.HEARTBEAT.equals((Object)headers.getMessageType())) {
            this.logger.trace((Object)"Encoded heartbeat");
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Encoded STOMP command=" + (Object)((Object)headers.getCommand()) + " headers=" + stompHeaders));
        }
        for (Map.Entry<String, List<String>> entry : stompHeaders.entrySet()) {
            byte[] key = this.getUtf8BytesEscapingIfNecessary(entry.getKey(), headers);
            for (String value : entry.getValue()) {
                output.write(key);
                output.write(58);
                output.write(this.getUtf8BytesEscapingIfNecessary(value, headers));
                output.write(10);
            }
        }
        if (headers.getCommand() == StompCommand.SEND || headers.getCommand() == StompCommand.MESSAGE || headers.getCommand() == StompCommand.ERROR) {
            output.write("content-length:".getBytes(UTF8_CHARSET));
            output.write(Integer.toString(message.getPayload().length).getBytes(UTF8_CHARSET));
            output.write(10);
        }
    }

    private void writeBody(Message<byte[]> message, DataOutputStream output) throws IOException {
        output.write(message.getPayload());
    }

    private byte[] getUtf8BytesEscapingIfNecessary(String input, StompHeaderAccessor headers) {
        if (headers.getCommand() != StompCommand.CONNECT && headers.getCommand() != StompCommand.CONNECTED) {
            return this.escape(input).getBytes(UTF8_CHARSET);
        }
        return input.getBytes(UTF8_CHARSET);
    }

    private String escape(String input) {
        return input.replaceAll("\\\\", "\\\\\\\\").replaceAll(":", "\\\\c").replaceAll("\n", "\\\\n").replaceAll("\r", "\\\\r");
    }
}

