/*
 * Decompiled with CFR 0.152.
 */
package org.apache.util;

import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.util.NSDecl;

public class NSStack {
    Vector nss = new Vector();
    int nssCount = 0;
    Vector tos = new Vector();
    private static final String nsPrefixPrefix = "ns";
    private int nsPrefixCount = 1;

    public void pushScope() {
        this.tos = new Vector();
        this.nss.addElement(this.tos);
        ++this.nssCount;
    }

    public void popScope() {
        this.nss.removeElementAt(--this.nssCount);
        this.tos = this.nssCount != 0 ? (Vector)this.nss.elementAt(this.nssCount - 1) : null;
    }

    public synchronized void addNSDeclaration(String prefix, String URI2) {
        this.tos.addElement(new NSDecl(prefix, URI2));
    }

    public synchronized String addNSDeclaration(String URI2) {
        String uniquePrefix = this.getPrefixFromURI(URI2);
        if (uniquePrefix == null) {
            while (this.getURIFromPrefix(uniquePrefix = nsPrefixPrefix + this.nsPrefixCount++) != null) {
            }
            this.addNSDeclaration(uniquePrefix, URI2);
        }
        return uniquePrefix;
    }

    public String getPrefixFromURI(String URI2) {
        int i = this.nssCount - 1;
        while (i >= 0) {
            Vector scope = (Vector)this.nss.elementAt(i);
            Enumeration e = scope.elements();
            while (e.hasMoreElements()) {
                NSDecl nsd = (NSDecl)e.nextElement();
                if (!nsd.URI.equals(URI2)) continue;
                return nsd.prefix;
            }
            --i;
        }
        return null;
    }

    public synchronized String getPrefixFromURI(String namespaceURI, Writer sink) throws IOException {
        String prefix = this.getPrefixFromURI(namespaceURI);
        if (prefix == null) {
            prefix = this.addNSDeclaration(namespaceURI);
            sink.write(" xmlns:" + prefix + "=\"" + namespaceURI + '\"');
        }
        return prefix;
    }

    public String getURIFromPrefix(String prefix) {
        int i = this.nssCount - 1;
        while (i >= 0) {
            Vector scope = (Vector)this.nss.elementAt(i);
            Enumeration e = scope.elements();
            while (e.hasMoreElements()) {
                NSDecl nsd = (NSDecl)e.nextElement();
                if (!nsd.prefix.equals(prefix)) continue;
                return nsd.URI;
            }
            --i;
        }
        return null;
    }

    public String getXmlns() {
        StringBuffer buffer = new StringBuffer();
        Enumeration e = this.tos.elements();
        while (e.hasMoreElements()) {
            NSDecl nsd = (NSDecl)e.nextElement();
            buffer.append(" xmlns:" + nsd.prefix + "=\"" + nsd.URI + "\"");
        }
        return buffer.toString();
    }

    public String toString() {
        return this.nss.toString();
    }
}

