/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.util.logger.jdk14;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class LogfileFormatter
extends Formatter {
    public static final String COMPLEX_FORMAT_STRING = "yyyy-MM-dd HH:mm:ss,SSSS";
    private SimpleDateFormat dateFormatter;

    public LogfileFormatter(String dateFormatPattern) {
        this.dateFormatter = new SimpleDateFormat(dateFormatPattern);
    }

    public LogfileFormatter() {
        this(COMPLEX_FORMAT_STRING);
    }

    public String format(LogRecord record) {
        boolean highlight = record.getLevel().intValue() > Level.INFO.intValue();
        StringBuffer message = new StringBuffer();
        Date logDate = new Date(record.getMillis());
        message.append(record.getSequenceNumber());
        message.append(" - ");
        message.append(this.dateFormatter.format(logDate));
        message.append(", ");
        message.append(record.getLevel());
        message.append(" [Thread: ");
        message.append(Thread.currentThread());
        message.append("] ");
        message.append(record.getLoggerName());
        message.append(" - ");
        message.append(record.getSourceMethodName());
        message.append(":\n");
        message.append(this.formatMessage(record));
        message.append("\n");
        if (record.getThrown() != null) {
            try {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                record.getThrown().printStackTrace(pw);
                pw.close();
                message.append(sw.toString());
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (highlight) {
            message.append("\n");
        }
        return message.toString();
    }
}

