/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.util.logger.jdk14;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class ConsoleLogfileFormatter
extends Formatter {
    public String format(LogRecord record) {
        boolean highlight = record.getLevel().intValue() > Level.INFO.intValue();
        StringBuffer message = new StringBuffer();
        if (highlight) {
            message.append("\n");
        }
        message.append(record.getSequenceNumber());
        message.append(" ");
        message.append(record.getLevel());
        message.append(" ");
        if (highlight) {
            message.append("\n");
        }
        message.append(record.getLoggerName());
        message.append(" - ");
        message.append(this.formatMessage(record));
        message.append("\n");
        if (record.getThrown() != null) {
            try {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                record.getThrown().printStackTrace(pw);
                pw.close();
                message.append(sw.toString());
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (highlight) {
            message.append("\n");
        }
        return message.toString();
    }
}

