/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.util.logger;

import org.apache.slide.util.logger.Logger;

public class StoreLogger {
    protected Logger logger;
    protected String logChannel;

    public StoreLogger() {
    }

    public StoreLogger(Logger logger, String logChannel) {
        this.logger = logger;
        this.logChannel = logChannel;
    }

    public StoreLogger cloneWithNewLogChannel(String logChannel) {
        return new StoreLogger(this.logger, logChannel);
    }

    public String getLogChannel() {
        return this.logChannel;
    }

    public void log(String message, int level) {
        if (this.logger != null) {
            this.logger.log(message, this.logChannel, level);
        }
    }

    public void log(String message, int level, Throwable t) {
        if (this.logger != null) {
            this.logger.log(message, this.logChannel, level);
            if (t != null) {
                this.logger.log(t, this.logChannel, level);
            }
        }
    }

    public void logInfo(String message) {
        this.log(message, 6);
    }

    public void logFine(String message) {
        this.log(message, 7);
    }

    public void logFiner(String message) {
        this.log(message, 7);
    }

    public void logFinest(String message) {
        this.log(message, 7);
    }

    public void logWarning(String message) {
        this.log(message, 4);
    }

    public void logWarning(String message, Throwable t) {
        this.log(message, 4, t);
    }

    public void logSevere(String message) {
        this.log(message, 0);
    }

    public void logSevere(String message, Throwable t) {
        this.log(message, 0, t);
    }
}

