/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.LRUMap;
import org.apache.slide.util.logger.Logger;

public class TxLRUObjectCache {
    protected Map globalCache;
    protected Map txChangeCaches;
    protected Map txDeleteCaches;
    protected int hits = 0;
    protected int misses = 0;
    protected String name;
    protected Logger logger;
    protected String logChannel;
    protected final boolean loggingEnabled;

    public TxLRUObjectCache(int globalCacheSize, String name, Logger logger) {
        this.globalCache = new LRUMap(globalCacheSize);
        this.txChangeCaches = new HashMap();
        this.txDeleteCaches = new HashMap();
        this.name = name;
        this.logger = logger;
        this.logChannel = "TxLRUObjectCache";
        if (name != null) {
            this.logChannel = this.logChannel + "." + name;
        }
        this.loggingEnabled = logger.isEnabled(this.logChannel, 7);
    }

    public TxLRUObjectCache(int globalCacheSize) {
        this(globalCacheSize, null, null);
    }

    public synchronized void clear() {
        this.globalCache.clear();
        this.txChangeCaches.clear();
        this.txDeleteCaches.clear();
    }

    public synchronized Object get(Object txId, Object key) {
        Object global;
        if (txId != null) {
            Set deleteCache = (Set)this.txDeleteCaches.get(txId);
            if (deleteCache.contains(key)) {
                this.hit(txId, key);
                return null;
            }
            Map changeCache = (Map)this.txChangeCaches.get(txId);
            Object changed = changeCache.get(key);
            if (changed != null) {
                this.hit(txId, key);
                return changed;
            }
        }
        if ((global = this.globalCache.get(key)) != null) {
            this.hit(txId, key);
        } else {
            this.miss(txId, key);
        }
        return global;
    }

    public synchronized void put(Object txId, Object key, Object value) {
        if (txId != null) {
            Set deleteCache = (Set)this.txDeleteCaches.get(txId);
            deleteCache.remove(key);
            Map changeCache = (Map)this.txChangeCaches.get(txId);
            changeCache.put(key, value);
            if (this.loggingEnabled) {
                this.logger.log(txId + " added '" + key + "'", this.logChannel, 7);
            }
        } else {
            this.globalCache.put(key, value);
            if (this.loggingEnabled) {
                this.logger.log("Added '" + key + "'", this.logChannel, 7);
            }
        }
    }

    public synchronized void remove(Object txId, Object key) {
        if (txId != null) {
            Map changeCache = (Map)this.txChangeCaches.get(txId);
            changeCache.remove(key);
            Set deleteCache = (Set)this.txDeleteCaches.get(txId);
            deleteCache.add(key);
            if (this.loggingEnabled) {
                this.logger.log(txId + " removed '" + key + "'", this.logChannel, 7);
            }
        } else {
            this.globalCache.remove(key);
            if (this.loggingEnabled) {
                this.logger.log("Removed '" + key + "'", this.logChannel, 7);
            }
        }
    }

    public synchronized void start(Object txId) {
        if (txId != null) {
            this.txChangeCaches.put(txId, new HashMap());
            this.txDeleteCaches.put(txId, new HashSet());
        }
    }

    public synchronized void rollback(Object txId) {
        if (txId != null) {
            if (this.loggingEnabled) {
                Map changeCache = (Map)this.txChangeCaches.get(txId);
                Set deleteCache = (Set)this.txDeleteCaches.get(txId);
                this.logger.log(txId + " rolled back " + changeCache.size() + " changes and " + deleteCache.size() + " scheduled deletes", this.logChannel, 7);
            }
            this.forget(txId);
        }
    }

    public synchronized void commit(Object txId) {
        if (txId != null) {
            Map changeCache = (Map)this.txChangeCaches.get(txId);
            Iterator it = changeCache.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                this.globalCache.put(entry.getKey(), entry.getValue());
            }
            Set deleteCache = (Set)this.txDeleteCaches.get(txId);
            Iterator it2 = deleteCache.iterator();
            while (it2.hasNext()) {
                Object key = it2.next();
                this.globalCache.remove(key);
            }
            if (this.loggingEnabled) {
                this.logger.log(txId + " committed " + changeCache.size() + " changes and " + deleteCache.size() + " scheduled deletes", this.logChannel, 7);
            }
            this.forget(txId);
        }
    }

    public synchronized void forget(Object txId) {
        if (txId != null) {
            this.txChangeCaches.remove(txId);
            this.txDeleteCaches.remove(txId);
        }
    }

    protected void hit(Object txId, Object key) {
        ++this.hits;
        this.log(txId, key, true);
    }

    protected void miss(Object txId, Object key) {
        ++this.misses;
        this.log(txId, key, false);
    }

    protected void log(Object txId, Object key, boolean hit) {
        if (this.loggingEnabled) {
            StringBuffer log = new StringBuffer();
            if (txId != null) {
                Map changeCache = (Map)this.txChangeCaches.get(txId);
                Set deleteCache = (Set)this.txDeleteCaches.get(txId);
                log.append(txId + " (" + changeCache.size() + ", " + deleteCache.size() + ") ");
            }
            log.append((hit ? "Cache Hit: '" : "Cache Miss: '") + key + "' " + this.hits + " / " + this.misses + " / " + this.globalCache.size());
            this.logger.log(log.toString(), this.logChannel, 7);
        }
    }
}

