/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.util;

import org.apache.slide.util.ObjectCache;

public abstract class AbstractObjectCache
implements ObjectCache {
    protected static final int DEFAULT_SIZE = 1000;
    protected static final double DEFAULT_HIT_RATIO = 0.8;
    protected int initialSize;
    protected double desiredHitRatio;
    protected int maxSize;
    protected double cacheRequests;
    protected double cacheHits;
    protected double currentHitRatio;

    public AbstractObjectCache() {
        this(1000, Integer.MAX_VALUE, 0.8);
    }

    public AbstractObjectCache(int initialSize, int maxSize, double desiredHitRatio) {
        this.initialSize = initialSize;
        this.maxSize = maxSize;
        this.desiredHitRatio = desiredHitRatio;
    }

    public abstract Object get(Object var1);

    public abstract void put(Object var1, Object var2);

    public abstract void remove(Object var1);

    public abstract void clear();

    protected abstract void removeSomeObjects();

    protected abstract int getSize();

    protected abstract void resize();

    protected void shouldResize() {
        if (this.cacheRequests > (double)this.getSize()) {
            this.currentHitRatio = this.cacheHits / this.cacheRequests;
            if (this.currentHitRatio > this.desiredHitRatio) {
                this.resize();
            }
        }
    }
}

