/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.store.txfile;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.apache.slide.common.ServiceAccessException;
import org.apache.slide.common.Uri;
import org.apache.slide.content.NodeProperty;
import org.apache.slide.content.NodeRevisionDescriptor;
import org.apache.slide.content.NodeRevisionDescriptors;
import org.apache.slide.content.NodeRevisionNumber;
import org.apache.slide.lock.NodeLock;
import org.apache.slide.store.txfile.TxXMLFileDescriptorsStore;
import org.apache.slide.store.txfile.rm.ResourceManagerException;
import org.apache.slide.store.txfile.rm.impl.FileResourceManager;
import org.apache.slide.structure.ObjectAlreadyExistsException;
import org.apache.slide.structure.ObjectNotFoundException;
import org.apache.slide.util.logger.StoreLogger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;
import slidestore.file.UriProperties;

public class XMLResourceDescriptor
extends UriProperties {
    private static String tmpDir;
    protected static final String PATH_EXTENSION = ".def.xml";
    protected final FileResourceManager rm;
    protected final TxXMLFileDescriptorsStore store;
    protected final String characterEncoding;
    protected volatile Object txId;
    protected volatile String uri;
    protected final String loadPath;
    protected StoreLogger logger;
    static /* synthetic */ Class class$org$apache$slide$store$txfile$XMLResourceDescriptor;

    public XMLResourceDescriptor(Uri uri, TxXMLFileDescriptorsStore store, FileResourceManager rm, Object txId, String characterEncoding) throws ServiceAccessException, ObjectNotFoundException {
        super(tmpDir, uri);
        this.logger = rm.getLogger().cloneWithNewLogChannel((class$org$apache$slide$store$txfile$XMLResourceDescriptor == null ? (class$org$apache$slide$store$txfile$XMLResourceDescriptor = XMLResourceDescriptor.class$("org.apache.slide.store.txfile.XMLResourceDescriptor")) : class$org$apache$slide$store$txfile$XMLResourceDescriptor).getName());
        this.rm = rm;
        this.store = store;
        this.characterEncoding = characterEncoding;
        this.txId = txId;
        if (uri == null) {
            store.throwInternalError("Trying to initialize XMLResourceDescriptor with null URI");
        }
        this.uri = uri.toString();
        this.loadPath = uri.toString() + PATH_EXTENSION;
        this.load();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public synchronized void save() throws ServiceAccessException, ObjectNotFoundException {
        block13: {
            if (this.txId == null) {
                this.store.throwInternalError("Not inside tx");
            }
            this.logger.logFine("Tx " + this.txId + " saves data for " + this.loadPath);
            OutputStream os = null;
            os = this.rm.writeResource(this.txId, this.loadPath);
            this.save(os);
            Object var4_2 = null;
            try {
                if (os != null) {
                    os.close();
                }
                break block13;
            }
            catch (IOException e2) {}
            break block13;
            {
                catch (ResourceManagerException e) {
                    if (e.getStatus() == 4002) {
                        throw new ObjectNotFoundException(this.uri);
                    }
                    this.store.throwInternalError(e, this.uri);
                    Object var4_3 = null;
                    try {
                        if (os != null) {
                            os.close();
                        }
                        break block13;
                    }
                    catch (IOException e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                try {
                    if (os != null) {
                        os.close();
                    }
                }
                catch (IOException e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    public synchronized void create() throws ServiceAccessException, ObjectAlreadyExistsException {
        this.logger.logFiner("Tx " + this.txId + " creates " + this.loadPath);
        if (this.txId == null) {
            this.store.throwInternalError("Not inside tx");
        }
        try {
            this.rm.createResource(this.txId, this.loadPath, false);
            this.init();
        }
        catch (ResourceManagerException e) {
            if (e.getStatus() == 4001) {
                throw new ObjectAlreadyExistsException(this.uri.toString());
            }
            this.store.throwInternalError(e, this.uri);
        }
    }

    public synchronized void delete() throws ServiceAccessException, ObjectNotFoundException {
        this.logger.logFiner("Tx " + this.txId + " deletes " + this.loadPath);
        if (this.txId == null) {
            this.store.throwInternalError("Not inside tx");
        }
        try {
            this.rm.deleteResource(this.txId, this.loadPath, false);
            this.object = null;
        }
        catch (ResourceManagerException e) {
            if (e.getStatus() == 4002) {
                throw new ObjectNotFoundException(this.uri.toString());
            }
            this.store.throwInternalError(e, this.uri);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public synchronized void load() throws ServiceAccessException, ObjectNotFoundException {
        block17: {
            InputStream is;
            block16: {
                this.logger.logFiner("Tx " + this.txId + " loads data for " + this.loadPath);
                is = null;
                this.logger.logFinest("Faking read access from outside tx for " + this.loadPath);
                if (this.txId != null) {
                    if (this.rm.resourceExists(this.txId, this.loadPath)) {
                        is = this.rm.readResource(this.txId, this.loadPath);
                        this.load(is);
                    } else {
                        this.init();
                    }
                    break block16;
                }
                if (this.rm.resourceExists(this.loadPath)) {
                    is = this.rm.readResource(this.loadPath);
                    this.load(is);
                    break block16;
                }
                this.init();
            }
            Object var4_2 = null;
            try {
                if (is != null) {
                    is.close();
                }
                break block17;
            }
            catch (IOException e2) {}
            break block17;
            {
                catch (ResourceManagerException e) {
                    if (e.getStatus() == 4002) {
                        throw new ObjectNotFoundException(this.uri);
                    }
                    this.store.throwInternalError(e, this.uri);
                    Object var4_3 = null;
                    try {
                        if (is != null) {
                            is.close();
                        }
                        break block17;
                    }
                    catch (IOException e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    public String getUri() {
        return this.uri;
    }

    public Object getTxId() {
        return this.txId;
    }

    public synchronized boolean equals(Object o) {
        return this == o || o != null && o instanceof XMLResourceDescriptor && ((XMLResourceDescriptor)((Object)o)).uri.equals(this.uri) && ((XMLResourceDescriptor)((Object)o)).txId.equals(this.txId);
    }

    public synchronized String toString() {
        return this.txId + ": " + this.uri;
    }

    protected synchronized void save(OutputStream os) throws ServiceAccessException {
        Element aRoot = this.encode();
        Document aDocument = new Document(aRoot);
        XMLOutputter aOutputter = new XMLOutputter();
        aOutputter.setEncoding(this.characterEncoding);
        aOutputter.setNewlines(true);
        aOutputter.setIndent("  ");
        aOutputter.setLineSeparator("\n");
        try {
            aOutputter.output(aDocument, os);
            os.flush();
        }
        catch (IOException e) {
            this.store.throwInternalError(e);
        }
    }

    public synchronized Element encodeObject() {
        if (this.object != null) {
            return super.encodeObject();
        }
        Element aElementObjectNode = new Element("objectnode");
        aElementObjectNode.setAttribute("classname", "null");
        aElementObjectNode.setAttribute("uri", this.uri.toString());
        aElementObjectNode.addContent(new Element("children"));
        aElementObjectNode.addContent(new Element("links"));
        return aElementObjectNode;
    }

    public synchronized void decodeObject(Element aElement) throws ServiceAccessException {
        Element aElementObjectNode = aElement.getChild("objectnode");
        String aClasseName = aElementObjectNode.getAttributeValue("classname");
        if (!"null".equals(aClasseName)) {
            super.decodeObject(aElement);
            this.uri = this.object.getUri();
        } else {
            this.object = null;
            this.uri = aElementObjectNode.getAttributeValue("uri");
        }
    }

    public synchronized void decodePermissions(Element aElement) {
        this.permissions = new Vector();
        Element aPermissions = aElement.getChild("permissions");
        List aList = aPermissions.getChildren();
        int i = 0;
        while (i < aList.size()) {
            Element aChild = (Element)aList.get(i);
            this.permissions.addElement(this.decodePermission(aChild, this.uri));
            ++i;
        }
    }

    public synchronized void decodeLocks(Element aElement) throws ServiceAccessException {
        try {
            this.locks = new Vector();
            Element aElementLocks = aElement.getChild("locks");
            List aList = aElementLocks.getChildren();
            int i = 0;
            while (i < aList.size()) {
                Element aChild = (Element)aList.get(i);
                String aSubject = aChild.getAttributeValue("subjectUri");
                String aType = aChild.getAttributeValue("typeUri");
                Date aDateExpiration = this.dateFormat.parse(aChild.getAttributeValue("date"));
                boolean aInheritable = new Boolean(aChild.getAttributeValue("inheritance"));
                boolean aNegative = new Boolean(aChild.getAttributeValue("exclusive"));
                String aLockId = aChild.getAttributeValue("lockId");
                String ownerInfo = aChild.getAttributeValue("owner");
                this.locks.addElement(new NodeLock(aLockId, this.uri, aSubject, aType, aDateExpiration, aInheritable, aNegative, ownerInfo));
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServiceAccessException(null, (Throwable)e);
        }
    }

    public synchronized void decodeRevisionDescriptors(Element aElement) {
        Element aRevisionsHistory = aElement.getChild("revisionsHistory");
        NodeRevisionNumber aInitialRevision = this.decodeRevisionNumber(aRevisionsHistory.getAttributeValue("initialRevision"));
        boolean aUseVersionning = new Boolean(aRevisionsHistory.getAttributeValue("useVersioning"));
        Element aBranchesElement = aRevisionsHistory.getChild("branches");
        if (aBranchesElement == null) {
            this.revisionDescriptors = new NodeRevisionDescriptors(this.uri, aInitialRevision, new Hashtable(), new Hashtable(), new Hashtable(), aUseVersionning);
            return;
        }
        List aList = aBranchesElement.getChildren();
        Hashtable<String, NodeRevisionNumber> aLastestRevisions = new Hashtable<String, NodeRevisionNumber>();
        int i = 0;
        while (i < aList.size()) {
            Element aChild = (Element)aList.get(i);
            String aName = aChild.getAttributeValue("name");
            NodeRevisionNumber aRevisionNumber = this.decodeRevisionNumber(aChild.getAttributeValue("lastestRevision"));
            aLastestRevisions.put(aName, aRevisionNumber);
            ++i;
        }
        Hashtable aBranches = new Hashtable();
        Element aRevisionsElement = aRevisionsHistory.getChild("revisions");
        aList = aRevisionsElement.getChildren();
        int i2 = 0;
        while (i2 < aList.size()) {
            Element aChild = (Element)aList.get(i2);
            NodeRevisionNumber aStartNumber = this.decodeRevisionNumber(aChild.getAttributeValue("start"));
            List aSuccessors = aChild.getChildren();
            Vector<NodeRevisionNumber> aSuccessorsNumbers = new Vector<NodeRevisionNumber>();
            int k = 0;
            while (k < aSuccessors.size()) {
                Element aSuccessor = (Element)aSuccessors.get(k);
                NodeRevisionNumber aRevisionNumber = this.decodeRevisionNumber(aSuccessor.getAttributeValue("number"));
                aSuccessorsNumbers.addElement(aRevisionNumber);
                ++k;
            }
            aBranches.put(aStartNumber, aSuccessorsNumbers);
            ++i2;
        }
        this.revisionDescriptors = new NodeRevisionDescriptors(this.uri, aInitialRevision, new Hashtable(), aLastestRevisions, aBranches, aUseVersionning);
    }

    public synchronized void decodeRevisionDescriptor(Element aParent) {
        this.descriptor = new Hashtable();
        Element aElement = aParent.getChild("descriptor");
        if (aElement == null) {
            return;
        }
        List aList = aElement.getChildren();
        int i = 0;
        while (i < aList.size()) {
            Element aChild = (Element)aList.get(i);
            String aBranchName = aChild.getAttributeValue("branchName");
            NodeRevisionNumber aRevisionNumber = this.decodeRevisionNumber(aChild.getAttributeValue("number"));
            Vector<String> aLabels = new Vector<String>();
            Element aLabelsElement = aChild.getChild("labels");
            List aLabelList = aLabelsElement.getChildren();
            int k = 0;
            while (k < aLabelList.size()) {
                Element aLabel = (Element)aLabelList.get(k);
                aLabels.addElement(aLabel.getAttributeValue("val"));
                ++k;
            }
            Hashtable<String, NodeProperty> aProperties = new Hashtable<String, NodeProperty>();
            Element aPropertiesElement = aChild.getChild("properties");
            List aPropertiesList = aPropertiesElement.getChildren();
            int k2 = 0;
            while (k2 < aPropertiesList.size()) {
                Element aProperty = (Element)aPropertiesList.get(k2);
                NodeProperty aProp = this.decodeNodeProperty(aProperty, this.uri);
                String key = aProperty.getAttributeValue("namespace") + aProperty.getAttributeValue("name");
                aProperties.put(key, aProp);
                ++k2;
            }
            NodeRevisionDescriptor aNode = new NodeRevisionDescriptor(aRevisionNumber, aBranchName, aLabels, aProperties);
            this.descriptor.put(aRevisionNumber.toString(), aNode);
            ++i;
        }
    }

    protected synchronized void load(InputStream is) throws ServiceAccessException {
        SAXBuilder aBuilder = new SAXBuilder();
        try {
            Document aDocument = aBuilder.build(is);
            this.decode(aDocument.getRootElement());
        }
        catch (JDOMException e) {
            this.store.throwInternalError(e);
        }
        catch (IOException e) {
            this.store.throwInternalError(e);
        }
    }

    protected synchronized void init() throws ServiceAccessException {
        this.object = null;
        this.permissions = new Vector();
        this.locks = new Vector();
        this.revisionDescriptors = new NodeRevisionDescriptors();
        this.descriptor = new Hashtable();
    }

    protected synchronized void save(Uri uri) throws ServiceAccessException {
        if (this.txId == null) {
            this.store.throwInternalError("Not inside tx");
        }
        try {
            this.save();
        }
        catch (ObjectNotFoundException e) {
            this.store.throwInternalError(e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            tmpDir = File.createTempFile("xyz", null).getParent();
        }
        catch (IOException e) {
            tmpDir = null;
        }
    }
}

