/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.store.txfile;

import java.io.File;
import java.util.Hashtable;
import javax.transaction.Status;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.apache.slide.common.AbstractServiceBase;
import org.apache.slide.common.Service;
import org.apache.slide.common.ServiceAccessException;
import org.apache.slide.common.ServiceConnectionFailedException;
import org.apache.slide.common.ServiceDisconnectionFailedException;
import org.apache.slide.common.ServiceParameterErrorException;
import org.apache.slide.common.ServiceParameterMissingException;
import org.apache.slide.macro.ConflictException;
import org.apache.slide.store.txfile.rm.ResourceManagerException;
import org.apache.slide.store.txfile.rm.impl.FileResourceManager;
import org.apache.slide.util.XidWrapper;
import org.apache.slide.util.logger.StoreLogger;

public abstract class AbstractTxFileStoreService
extends AbstractServiceBase
implements Status {
    protected static final String LOG_CHANNEL = (class$org$apache$slide$store$txfile$AbstractTxFileStoreService == null ? (class$org$apache$slide$store$txfile$AbstractTxFileStoreService = AbstractTxFileStoreService.class$("org.apache.slide.store.txfile.AbstractTxFileStoreService")) : class$org$apache$slide$store$txfile$AbstractTxFileStoreService).getName();
    protected static final String STORE_DIR_PARAMETER = "rootpath";
    protected static final String WORK_DIR_PARAMETER = "workpath";
    protected static final String TIMEOUT_PARAMETER = "timeout";
    protected static final String URLENCODE_PATH = "url-encode-path";
    protected FileResourceManager rm;
    protected boolean started = false;
    protected String storeDir;
    protected String workDir;
    protected ThreadLocal activeTransactionBranch = new ThreadLocal();
    static /* synthetic */ Class class$org$apache$slide$store$txfile$AbstractTxFileStoreService;
    static /* synthetic */ Class class$org$apache$slide$store$txfile$rm$impl$FileResourceManager;

    public void setParameters(Hashtable parameters) throws ServiceParameterErrorException, ServiceParameterMissingException {
        block5: {
            this.storeDir = (String)parameters.get(STORE_DIR_PARAMETER);
            this.workDir = (String)parameters.get(WORK_DIR_PARAMETER);
            if (this.storeDir == null) {
                throw new ServiceParameterMissingException(this, STORE_DIR_PARAMETER);
            }
            if (this.workDir == null) {
                throw new ServiceParameterMissingException(this, WORK_DIR_PARAMETER);
            }
            new File(this.storeDir).mkdirs();
            new File(this.workDir).mkdirs();
            boolean urlEncodePath = false;
            String urlEncodePathString = (String)parameters.get(URLENCODE_PATH);
            if (urlEncodePathString != null) {
                urlEncodePath = "true".equals(urlEncodePathString);
            }
            this.rm = new FileResourceManager(this.storeDir, this.workDir, urlEncodePath, new StoreLogger(this.getLogger(), (class$org$apache$slide$store$txfile$rm$impl$FileResourceManager == null ? (class$org$apache$slide$store$txfile$rm$impl$FileResourceManager = AbstractTxFileStoreService.class$("org.apache.slide.store.txfile.rm.impl.FileResourceManager")) : class$org$apache$slide$store$txfile$rm$impl$FileResourceManager).getName()));
            this.getLogger().log("File Store configured to " + this.storeDir + ", working directory " + this.workDir, LOG_CHANNEL, 6);
            String timeoutString = (String)parameters.get(TIMEOUT_PARAMETER);
            if (timeoutString == null) break block5;
            try {
                int timeout = Integer.parseInt(timeoutString);
                this.rm.setDefaultTransactionTimeout(timeout * 1000);
                this.getLogger().log("Set timeout to " + timeoutString, LOG_CHANNEL, 6);
            }
            catch (NumberFormatException nfe) {
                this.getLogger().log("Can not set timeout, '" + timeoutString + "' must be an integer!", LOG_CHANNEL, 4);
            }
        }
    }

    public String toString() {
        return "TxFileStore at " + this.storeDir + "  working on " + this.workDir;
    }

    public void connect() throws ServiceConnectionFailedException {
        try {
            this.rm.start();
            this.started = true;
        }
        catch (ResourceManagerException e) {
            throw new ServiceConnectionFailedException((Service)this, e);
        }
    }

    public void disconnect() throws ServiceDisconnectionFailedException {
        try {
            if (!this.rm.stop(0)) {
                throw new ServiceDisconnectionFailedException((Service)this, "Shut down timed out");
            }
            this.started = false;
        }
        catch (ResourceManagerException e) {
            throw new ServiceDisconnectionFailedException((Service)this, e);
        }
    }

    public boolean isConnected() throws ServiceAccessException {
        return this.started;
    }

    public void reset() {
        this.rm.reset();
    }

    public int getTransactionTimeout() throws XAException {
        try {
            long msecs = this.rm.getTransactionTimeout(this.getActiveTxId());
            return Math.round((float)msecs / 1000.0f);
        }
        catch (ResourceManagerException e) {
            this.throwXAException(e);
            return -1;
        }
    }

    public boolean setTransactionTimeout(int seconds) throws XAException {
        try {
            this.rm.setTransactionTimeout(this.getActiveTxId(), seconds * 1000);
        }
        catch (ResourceManagerException e) {
            this.throwXAException(e);
        }
        return true;
    }

    public boolean isSameRM(XAResource xares) throws XAException {
        return xares instanceof AbstractTxFileStoreService && ((AbstractTxFileStoreService)xares).rm.equals(this.rm);
    }

    public synchronized Xid[] recover(int flag) throws XAException {
        return null;
    }

    public synchronized void forget(Xid xid) throws XAException {
    }

    public synchronized int prepare(Xid xid) throws XAException {
        Xid txId = XidWrapper.wrap(xid);
        this.getLogger().log("Thread " + Thread.currentThread() + " prepares transaction branch " + txId, LOG_CHANNEL, 7);
        try {
            int status = this.rm.prepareTransaction(txId);
            switch (status) {
                case 2: {
                    return 3;
                }
                case 1: {
                    return 0;
                }
            }
            throw new XAException(100);
        }
        catch (ResourceManagerException e) {
            this.getLogger().log("Thread " + Thread.currentThread() + " failed to prepare transaction branch " + txId, e, LOG_CHANNEL, 1);
            this.throwXAException(e);
            return 0;
        }
    }

    public synchronized void rollback(Xid xid) throws XAException {
        Xid txId = XidWrapper.wrap(xid);
        this.getLogger().log("Thread " + Thread.currentThread() + " rolls back transaction branch " + txId, LOG_CHANNEL, 7);
        try {
            this.rm.rollbackTransaction(txId);
            this.activeTransactionBranch.set(null);
        }
        catch (ResourceManagerException e) {
            this.getLogger().log("Thread " + Thread.currentThread() + " failed to roll back transaction branch " + txId, e, LOG_CHANNEL, 1);
            this.throwXAException(e);
        }
    }

    public synchronized void commit(Xid xid, boolean onePhase) throws XAException {
        Xid txId = XidWrapper.wrap(xid);
        this.getLogger().log("Thread " + Thread.currentThread() + " commits transaction branch " + txId, LOG_CHANNEL, 7);
        try {
            if (!onePhase && this.rm.getTransactionState(txId) != 2) {
                throw new XAException(-5);
            }
            this.rm.commitTransaction(txId);
            this.activeTransactionBranch.set(null);
        }
        catch (ResourceManagerException e) {
            this.getLogger().log("Thread " + Thread.currentThread() + " failed to commit transaction branch " + txId, e, LOG_CHANNEL, 1);
            this.throwXAException(e);
        }
    }

    public synchronized void end(Xid xid, int flags) throws XAException {
        Xid txId = XidWrapper.wrap(xid);
        this.getLogger().log("Thread " + Thread.currentThread() + " ends work on behalf of transaction branch " + txId + " with flags " + flags, LOG_CHANNEL, 7);
        switch (flags) {
            case 0x2000000: {
                this.getLogger().log("Thread of control suspends work on behalf of transaction branch", LOG_CHANNEL, 7);
                break;
            }
            case 0x20000000: {
                this.getLogger().log("Transaction branch failed", LOG_CHANNEL, 7);
                try {
                    this.rm.markTransactionForRollback(XidWrapper.wrap(xid));
                }
                catch (ResourceManagerException e) {
                    this.throwXAException(e);
                }
                break;
            }
            case 0x4000000: {
                this.getLogger().log("Transaction branch successfully completed", LOG_CHANNEL, 7);
            }
        }
    }

    public synchronized void start(Xid xid, int flags) throws XAException {
        Xid txId = XidWrapper.wrap(xid);
        this.getLogger().log("Thread " + Thread.currentThread() + " starts work on behalf of transaction branch " + txId + " with flags " + flags, LOG_CHANNEL, 7);
        switch (flags) {
            case 0: {
                this.getLogger().log("Starting new transaction branch", LOG_CHANNEL, 7);
                if (this.getActiveTxId() != null) {
                    throw new XAException(-5);
                }
                try {
                    this.rm.startTransaction(txId);
                    this.activeTransactionBranch.set(txId);
                }
                catch (ResourceManagerException e) {
                    this.throwXAException(e);
                }
                break;
            }
            case 0x200000: {
                this.getLogger().log("Thread of control joins known transaction branch", LOG_CHANNEL, 7);
                if (this.getActiveTxId() != null) {
                    throw new XAException(-5);
                }
                try {
                    if (this.rm.getTransactionState(txId) == 6) {
                        throw new XAException(-5);
                    }
                }
                catch (ResourceManagerException e) {
                    this.throwXAException(e);
                }
                this.activeTransactionBranch.set(txId);
                break;
            }
            case 0x8000000: {
                this.getLogger().log("Thread of control resume work on known transaction branch", LOG_CHANNEL, 7);
            }
        }
    }

    public synchronized void throwInternalError(String cause) throws ServiceAccessException {
        Object txId = this.getActiveTxId();
        this.getLogger().log("Thread " + Thread.currentThread() + " marked transaction branch " + txId + " for rollback. Cause: " + cause, LOG_CHANNEL, 4);
        try {
            this.rm.markTransactionForRollback(txId);
        }
        catch (ResourceManagerException re) {
            throw new ServiceAccessException((Service)this, (Throwable)re);
        }
        throw new ServiceAccessException((Service)this, cause);
    }

    public synchronized void throwInternalError(Throwable cause) throws ServiceAccessException {
        Object txId = this.getActiveTxId();
        this.getLogger().log("Thread " + Thread.currentThread() + " marked transaction branch " + txId + " for rollback. Cause: " + cause, LOG_CHANNEL, 4);
        try {
            this.rm.markTransactionForRollback(txId);
        }
        catch (ResourceManagerException re) {
            throw new ServiceAccessException((Service)this, (Throwable)re);
        }
        throw new ServiceAccessException((Service)this, cause);
    }

    public synchronized void throwInternalError(Throwable cause, String uri) throws ServiceAccessException {
        Object txId = this.getActiveTxId();
        if (cause instanceof ResourceManagerException && ((ResourceManagerException)cause).getStatus() == 5001) {
            if (txId != null) {
                try {
                    this.rm.markTransactionForRollback(txId);
                }
                catch (ResourceManagerException re) {
                    throw new ServiceAccessException((Service)this, (Throwable)re);
                }
            }
            this.getLogger().log("DEADLOCK VICTIM: Thread " + Thread.currentThread() + " marked transaction branch " + txId + " for rollback", LOG_CHANNEL, 6);
            throw new ServiceAccessException((Service)this, (Throwable)new ConflictException(uri));
        }
        this.getLogger().log("Thread " + Thread.currentThread() + " marking transaction branch " + txId + " for rollback", cause, LOG_CHANNEL, 4);
        if (txId != null) {
            try {
                this.rm.markTransactionForRollback(txId);
            }
            catch (ResourceManagerException re) {
                throw new ServiceAccessException((Service)this, (Throwable)re);
            }
        }
        throw new ServiceAccessException((Service)this, cause);
    }

    protected Object getActiveTxId() {
        Object txId = this.activeTransactionBranch.get();
        return txId;
    }

    protected void throwXAException(ResourceManagerException e) throws XAException {
        if (e.getStatus() == 1004) {
            throw new XAException(-8);
        }
        if (e.getStatus() == 1001) {
            throw new XAException(-4);
        }
        throw new XAException(e.toString());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

