/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.store.impl.rdbms;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Hashtable;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.DriverManagerConnectionFactory;
import org.apache.commons.dbcp.PoolableConnectionFactory;
import org.apache.commons.dbcp.PoolingDriver;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.apache.slide.common.NamespaceAccessToken;
import org.apache.slide.common.Service;
import org.apache.slide.common.ServiceInitializationFailedException;
import org.apache.slide.common.ServiceParameterErrorException;
import org.apache.slide.common.ServiceParameterMissingException;
import org.apache.slide.store.ContentStore;
import org.apache.slide.store.LockStore;
import org.apache.slide.store.NodeStore;
import org.apache.slide.store.RevisionDescriptorStore;
import org.apache.slide.store.RevisionDescriptorsStore;
import org.apache.slide.store.SecurityStore;
import org.apache.slide.store.impl.rdbms.AbstractRDBMSStore;

public class JDBCStore
extends AbstractRDBMSStore
implements LockStore,
NodeStore,
RevisionDescriptorsStore,
RevisionDescriptorStore,
SecurityStore,
ContentStore {
    public static final String DBCP_URL = "jdbc:apache:commons:dbcp";
    public static final String DBCP_POOL_NAME = "dbcpPool";
    public static final String TRANSACTION_NONE = "NONE";
    public static final String TRANSACTION_READ_UNCOMMITTED = "READ_UNCOMMITTED";
    public static final String TRANSACTION_READ_COMMITTED = "READ_COMMITTED";
    public static final String TRANSACTION_REPEATABLE_READ = "REPEATABLE_READ";
    public static final String TRANSACTION_SERIALIZABLE = "SERIALIZABLE";
    public static final int DEFAUT_ISOLATION_LEVEL = 2;
    protected String driver;
    protected String url;
    protected String user = "";
    protected String password = "";
    protected boolean useDbcpPooling = false;
    protected int maxPooledConnections = -1;
    protected int isolationLevel = 2;

    protected static String isolationLevelToString(int isolationLevel) {
        String levelString;
        switch (isolationLevel) {
            case 0: {
                levelString = TRANSACTION_NONE;
                break;
            }
            case 1: {
                levelString = TRANSACTION_READ_UNCOMMITTED;
                break;
            }
            case 2: {
                levelString = TRANSACTION_READ_COMMITTED;
                break;
            }
            case 4: {
                levelString = TRANSACTION_REPEATABLE_READ;
                break;
            }
            case 8: {
                levelString = TRANSACTION_SERIALIZABLE;
                break;
            }
            default: {
                levelString = "UNKNOWN";
            }
        }
        return levelString;
    }

    protected static int stringToIsolationLevelToString(String levelString) {
        if (TRANSACTION_NONE.equals(levelString)) {
            return 0;
        }
        if (TRANSACTION_READ_UNCOMMITTED.equals(levelString)) {
            return 1;
        }
        if (TRANSACTION_READ_COMMITTED.equals(levelString)) {
            return 2;
        }
        if (TRANSACTION_REPEATABLE_READ.equals(levelString)) {
            return 4;
        }
        if (TRANSACTION_SERIALIZABLE.equals(levelString)) {
            return 8;
        }
        return -1;
    }

    public void setParameters(Hashtable parameters) throws ServiceParameterErrorException, ServiceParameterMissingException {
        String value = (String)parameters.get("driver");
        if (value == null) {
            throw new ServiceParameterMissingException(this, "driver");
        }
        this.driver = value;
        value = (String)parameters.get("url");
        if (value == null) {
            throw new ServiceParameterMissingException(this, "url");
        }
        this.url = value;
        value = (String)parameters.get("user");
        if (value != null) {
            this.user = value;
        }
        if ((value = (String)parameters.get("password")) != null) {
            this.password = value;
        }
        if ((value = (String)parameters.get("isolation")) != null) {
            this.isolationLevel = JDBCStore.stringToIsolationLevelToString(value);
            if (this.isolationLevel == -1) {
                this.getLogger().log("Could not set isolation level '" + value + "', allowed levels are " + TRANSACTION_NONE + ", " + TRANSACTION_READ_UNCOMMITTED + ", " + TRANSACTION_READ_COMMITTED + ", " + TRANSACTION_REPEATABLE_READ + ", " + TRANSACTION_SERIALIZABLE, this.LOG_CHANNEL, 4);
                this.isolationLevel = 2;
            }
        }
        if ((value = (String)parameters.get("dbcpPooling")) != null) {
            this.useDbcpPooling = "true".equals(value);
        }
        if (this.useDbcpPooling && (value = (String)parameters.get("maxPooledConnections")) != null) {
            try {
                this.maxPooledConnections = Integer.parseInt(value);
            }
            catch (NumberFormatException nfe) {
                this.getLogger().log("Could not set maximum pooled connections, parameter must be integer", this.LOG_CHANNEL, 4);
            }
        }
        super.setParameters(parameters);
    }

    public synchronized void initialize(NamespaceAccessToken token) throws ServiceInitializationFailedException {
        if (!this.alreadyInitialized) {
            try {
                block7: {
                    try {
                        this.getLogger().log("Loading and registering driver '" + this.driver + "'", this.LOG_CHANNEL, 6);
                        Class<?> driverClass = Class.forName(this.driver);
                        Driver driverInstance = (Driver)driverClass.newInstance();
                        String levelString = JDBCStore.isolationLevelToString(this.isolationLevel);
                        this.getLogger().log("Setting isolation level '" + levelString + "'", this.LOG_CHANNEL, 6);
                        if (this.useDbcpPooling) {
                            this.getLogger().log("Using DBCP pooling", this.LOG_CHANNEL, 6);
                            GenericObjectPool connectionPool = new GenericObjectPool(null);
                            if (this.maxPooledConnections != -1) {
                                connectionPool.setMaxActive(this.maxPooledConnections);
                            }
                            this.getLogger().log("Number of connections set to " + connectionPool.getMaxActive(), this.LOG_CHANNEL, 6);
                            DriverManagerConnectionFactory connectionFactory = new DriverManagerConnectionFactory(this.url, this.user, this.password);
                            new PoolableConnectionFactory((ConnectionFactory)connectionFactory, (ObjectPool)connectionPool, null, null, false, false, this.isolationLevel);
                            PoolingDriver driver = new PoolingDriver();
                            driver.registerPool(DBCP_POOL_NAME, (ObjectPool)connectionPool);
                            break block7;
                        }
                        DriverManager.registerDriver(driverInstance);
                        this.getLogger().log("Not using DBCP pooling", this.LOG_CHANNEL, 4);
                    }
                    catch (Exception e) {
                        this.getLogger().log("Loading and registering driver '" + this.driver + "' failed (" + e.getMessage() + ")", this.LOG_CHANNEL, 2);
                        throw new ServiceInitializationFailedException((Service)this, e);
                    }
                }
                Object var9_9 = null;
                this.alreadyInitialized = true;
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                this.alreadyInitialized = true;
                throw throwable;
            }
        }
    }

    protected Connection getNewConnection() throws SQLException {
        Connection connection;
        if (this.useDbcpPooling) {
            try {
                connection = DriverManager.getConnection("jdbc:apache:commons:dbcp:dbcpPool");
            }
            catch (SQLException e) {
                this.getLogger().log("Could not create connection. Reason: " + e, this.LOG_CHANNEL, 0);
                throw e;
            }
        }
        try {
            connection = DriverManager.getConnection(this.url, this.user, this.password);
        }
        catch (SQLException e) {
            this.getLogger().log("Could not create connection. Reason: " + e, this.LOG_CHANNEL, 0);
            throw e;
        }
        try {
            if (connection.getTransactionIsolation() != this.isolationLevel) {
                connection.setTransactionIsolation(this.isolationLevel);
            }
        }
        catch (SQLException e) {
            this.getLogger().log("Could not set isolation level '" + JDBCStore.isolationLevelToString(this.isolationLevel) + "'. Reason: " + e, this.LOG_CHANNEL, 4);
        }
        if (connection.getAutoCommit()) {
            connection.setAutoCommit(false);
        }
        return connection;
    }
}

